-- ================================================================================================
-- HEALTH PLANT
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")

particleDelay = 0
out = 32
-- ================================================================================================
-- L O C A L  V A R I A B L E S 
-- ================================================================================================

-- ================================================================================================
-- FUNCTIONS
-- ================================================================================================

function init(me)
	setupBasicEntity(
	me,
	"HealthPlant",					-- texture
	15,								-- health
	2,								-- manaballamount
	2,								-- exp
	1,								-- money
	32,								-- collideRadius (for hitting entities + spells)
	STATE_IDLE,						-- initState
	64,								-- sprite width	
	128,							-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	1,								-- 0/1 hit other entities off/on (uses collideRadius)
	2000							-- updateCull -1: disabled, default: 4000
	)
	entity_setEntityType(me, ET_NEUTRAL)
	entity_setSegs(me, 2, 8, 0.3, 0.1, -0.018, 0, 6, 0)
end

function update(me, dt)
	if entity_isState(me, STATE_IDLE) then
		particleDelay = particleDelay - dt
		if particleDelay < 0 then
			particleDelay = 0.6
			nx, ny = entity_getNormal(me)
			nx = nx * out
			ny = ny * out
			spawnParticleEffect("HealthPlantGlow", entity_x(me)+nx, entity_y(me)+ny)
		end
		
		if entity_isEntityInRange(me, getNaija(), 64) then
			spawnManaBall(entity_x(getNaija()), entity_y(getNaija()), 1)
			entity_setState(me, STATE_USED)
		elseif entity_isEntityInRange(me, getNaija(), 580) and avatar_isRolling() then
			nx, ny = entity_getNormal(me)			
			nx = nx * out
			ny = ny * out		
			spawnManaBall(entity_x(me)+nx, entity_y(me)+ny, 1)
			entity_setState(me, STATE_USED)		
		end
	elseif entity_isState(me, STATE_USED) then
		
	end
end

function enterState(me)
	if entity_isState(me, STATE_USED) then		
	elseif entity_isState(me, STATE_IDLE) then
	end
end

function animationKey(me, key)
end

function exitState(me)
end

function hitSurface(me)
end
