-- last known coordinates of Nautilus Prime
lx = 0
ly = 0

-- start out not having spawned the orb
spawned = false

function init(me)
end

function update(me, dt)
	if not spawned then
		naut = getEntityByName("nautilusprime")
		
		-- if nautilus prime exists...
		if naut ~= 0 then
			-- store her location for later
			lx, ly = entity_getPosition(naut)
		else
			-- no nautilus prime! she must have died
			
			-- second parameter is a name override
			orb = createEntity("EnergyOrb", "", lx, ly)
			
			-- do a fade-in effect
			
			-- set the orb to 0 transparency, invisible
			entity_alpha(orb, 0)
			
			-- set it to 1.0 full transparency over 1.0 seconds
			entity_alpha(orb, 1, 1)
			
			-- make sure we only spawn the orb once!
			spawned = true
		end
	end	
end
