dofile("scripts/entities/entityinclude.lua")
dofile(appendUserDataPath("_mods/jukebox/scripts/jukeboxinclude.lua"))

--[[
Button layout on screen:

         RAND
  PREV          NEXT 
  
                    *EXIT*
--]]

local navmap = {
    [ACTION_MENUUP] = "jukebox-random",
    [ACTION_MENULEFT] = "jukebox-previous",
    [ACTION_MENURIGHT] = "jukebox-next"
}

function init(me)
	node_setCursorActivation(me, true)
	node_setCatchActions(me, true)
end

function action(me, action, state)
	if isNestedMain() then return end
	return jukebox_doButtonAction(me, action, state, navmap)
end

function activate(me)
	if isNestedMain() then return end

	playSfx("TitleAction")
	spawnParticleEffect("TitleEffect1", node_x(me), node_y(me))
	watch(0.5)
	
	doQuit = false
	
	if confirm("", "exit") then
		doQuit = true
	end

	setNodeToActivate(0)
	stopCursorGlow()
	
	if doQuit then
		fadeOutMusic(2)
		toggleCursor(false)
		fade(1, 2, 0, 0, 0)
		watch(2)
		watch(0.5)
		goToTitle()
	end
end

function update(me, dt)
end
