dofile("scripts/entities/entityinclude.lua")

n = 0
bone_tentacles = 0
fireDelay = 0

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_ENEMY)
	entity_initSkeletal(me, "Abaddon")	
	--entity_setAllDamageTargets(me, true)
	
	entity_generateCollisionMask(me)	
		
	bone_tentacles = entity_getBoneByName(me, "Tentacles")	
	
	entity_setDeathParticleEffect(me, "BigRedExplode")
	entity_setDeathScene(me, true)
	
	entity_setHealth(me, 24)
	entity_setState(me, STATE_IDLE)
	entity_setCullRadius(me, 512)
	
	entity_setUpdateCull(me, 3000)
	
	entity_setDropChance(me, 100, 1)
	
	entity_setDamageTarget(me, DT_ENEMY_BEAM, false)
	entity_setDamageTarget(me, DT_AVATAR_LIZAP, false)
	entity_setDamageTarget(me, DT_AVATAR_PET, false)
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
	entity_handleShotCollisionsSkeletal(me)
	bone = entity_collideSkeletalVsCircle(me, n)
	if bone ~= 0 then
		entity_touchAvatarDamage(me, 0, 1, 400)
	end
	
	fireDelay = fireDelay + dt
	if fireDelay > 4 then
		fireDelay = 0
		radius = 64
		maxa = 3.14 * 2
		off = bone_getRotation(bone_tentacles)
		a = off
		while a < maxa+off do
			s= createShot("Abaddon", me)
			shot_setAimVector(s, math.sin(a), math.cos(a))		
			shot_setOut(s, radius)
			a = a + (3.14*2)/8.0
		end
	end
	entity_updateMovement(me, dt)
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		bone_rotate(bone_tentacles, 360, 10, -1)
	elseif entity_isState(me, STATE_DEATHSCENE) then
		t = 2
		entity_offset(me, 10, 0, 0.05, -1, 1)
		entity_setStateTime(me, t)
		entity_scale(me, 0.2, 0.2, t, 0, 1)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	if bone == bone_tentacles then
		return false
	end
	return true
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

