dofile("scripts/entities/entityinclude.lua")

n = 0
attached = 0
bone_attach = 0

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_ENEMY)
	entity_initSkeletal(me, "airship")

	for i=1,2 do
		blade = entity_getBoneByIdx(me, i)
		bone_scale(blade, 0.1, 1, 0.1, -1, 1)
	end
	
	entity_setState(me, STATE_IDLE)
	
	entity_scale(me, 1.2, 1.2)
	
	entity_setCull(me, false)
	
	entity_setEntityLayer(me, 1)
	
	entity_fh(me)
	
	bone_attach = entity_getBoneByName(me, "attach")
	bone_alpha(bone_attach, 0)
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
	if attached then
		bx, by = bone_getWorldPosition(bone_attach)
		entity_setPosition(attached, bx, by)
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

function msg(me, msg, v)
	if msg == "attach" then
		attached = v
	end
end


