dofile("scripts/entities/entityinclude.lua")

n = 0

maxFireDelay = 2

fireDelay = maxFireDelay

btm = 0

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_ENEMY)
	entity_initSkeletal(me, "aleph")	
	entity_setAllDamageTargets(me, false)
	
	entity_generateCollisionMask(me)
	
	entity_setState(me, STATE_IDLE)
	
	btm = entity_getBoneByName(me, "btm")
	
	bone_alpha(btm, 0.5, 0.1, -1, 1)
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
	entity_updateMovement(me, dt)

	entity_handleShotCollisionsSkeletal(me)
	bone = entity_collideSkeletalVsCircle(me, n)
	
	if bone ~= 0 then
		if avatar_isBursting() and entity_setBoneLock(n, me, bone) then
		else
			bx, by = bone_getWorldPosition(bone)
			x, y = entity_getPosition(n)
			x = x - bx
			y = y - by
			x,y = vector_setLength(x, y, 2000)
			entity_clearVel(n)
			entity_addVel(n, x, y)
		end
	end
	
	fireDelay = fireDelay - dt
	if fireDelay <= 0 then
		fireDelay = maxFireDelay
		s = createShot("creatorform6-hand", me, n)
		shot_setOut(s, 64)
		shot_setAimVector(s, 0, 800)
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

