dofile("scripts/entities/entityinclude.lua")

containedEntity = 0
naija = 0
button = 0
door = 0
sacrificed = false

function init(me)	
	entity_setEntityType(me, ET_NEUTRAL)
	entity_initSkeletal(me, "Altar", "")
	--entity_animate(me, "open")
	entity_setEntityLayer(me, 0)
	entity_setState(me, STATE_OPEN)
	
	--entity_generateCollisionMask(me)
	--entity_setPasses(me, 2)
	
	naija = getNaija()	
end

function postInit(me)
	door = entity_getNearestEntity(me, "EnergyDoor")
	if entity_isFlag(me, 1) then
		entity_setState(door, STATE_OPENED)
	end
end

function update(me, dt)
	if button == 0 then
		button = entity_getNearestEntity(me, "SacrificeButton")
	end
	
	if entity_isState(me, STATE_OPEN) and not entity_isAnimating(me) then
		entity_setState(me, STATE_OPENED)
	end
	if entity_isState(me, STATE_CLOSE) and not entity_isAnimating(me) then
		entity_setState(me, STATE_ON, 5)
	end
	if entity_isState(me, STATE_OFF) and not entity_isInterpolating(me) then
		entity_setState(me, STATE_OPEN)
	end
	if entity_isState(me, STATE_ON) then
	end
	if containedEntity ~= 0 then
		entity_setPosition(containedEntity, entity_x(me), entity_y(me))
	end
	if entity_isState(me, STATE_OPENED) then
		if containedEntity == 0 then
			victim = entity_getNearestEntity(me, "SacrificeVictim")
			if victim ~=0 then
				--debugLog("victim!")
				if entity_isEntityInRange(me, victim, 128) then					
					containedEntity = victim
					entity_stopPull(containedEntity)
				end
			end
		end
	end
end

function enterState(me, state)
	if entity_isState(me, STATE_OPEN) then
		entity_setState(button, STATE_OPEN)
		entity_animate(me, "open")
		if sacrificed then
			if door ~= 0 then
				cam_toEntity(door)
				entity_setState(door, STATE_OPEN)
				watch(1.5)
				cam_toEntity(getNaija())
			end
			sacrificed = false
		end
	elseif entity_isState(me, STATE_CLOSE) then
		entity_animate(me, "close")
		entity_setState(button, STATE_CLOSE)
	elseif entity_isState(me, STATE_CLOSED) then
	elseif entity_isState(me, STATE_ON) then
		-- uncomment to catch naija
		--[[
		if containedEntity == 0 then
			if entity_isEntityInRange(me, naija, 128) then
				containedEntity = naija
			end
		end
		]]--
		entity_move(me, entity_x(me), entity_y(me)+2000, 4, 0, 0, 0, 1)
	elseif entity_isState(me, STATE_OFF) then
		
		entity_move(me, entity_x(me), entity_y(me)-2000, 4, 0, 0, 0, 1)		
	end
end

function exitState(me, state)
	if entity_isState(me, STATE_CLOSE) then
		--entity_setState(me, STATE_ON, 5)
	elseif entity_isState(me, STATE_ON) then
		if containedEntity ~= 0 and entity_isName(containedEntity, "SacrificeVictim") then
			sacrificed = true
			playSfx("HellBeast-Roar")
			shakeCamera(5, 3)
			entity_setFlag(me, 1)
			entity_setState(me, STATE_DELAY, 4)
		else
			entity_setState(me, STATE_DELAY, 2)
		end
		if entity_getEntityType(containedEntity) ~= ET_AVATAR then
			entity_setFlag(containedEntity, 1)
		end
		containedEntity = 0
	elseif entity_isState(me, STATE_DELAY) then
		entity_setState(me, STATE_OFF)
	elseif entity_isState(me, STATE_OFF) then
		--entity_setState(me, STATE_OPEN)		
	end
end

