-- ================================================================================================
-- A N E M O N E
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")

-- ================================================================================================
-- FUNCTIONS
-- ================================================================================================

function init(me)
	setupBasicEntity(
	me,
	"Anemone-0003",						-- texture
	9,								-- health
	1,								-- manaballamount
	1,								-- exp
	0,								-- money
	48,								-- collideRadius (for hitting entities + spells)
	STATE_IDLE,						-- initState
	128,							-- sprite width	
	256,							-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	1,								-- 0/1 hit other entities off/on (uses collideRadius)
	4000							-- updateCull -1: disabled, default: 4000
	)
	entity_setSegs(me, 2, 10, 6.0, 4.0, -0.02, 0, 2.5, 1)
	entity_setDeathParticleEffect(me, "AnemoneExplode")
	entity_setDamageTarget(me, DT_AVATAR_ENERGYBLAST, false)
	entity_setDamageTarget(me, DT_AVATAR_SHOCK, false)
	entity_setDamageTarget(me, DT_AVATAR_LIZAP, false)
	entity_setDamageTarget(me, DT_AVATAR_PET, false)
	entity_setTargetPriority(me, -1)
end

function update(me, dt)
	entity_handleShotCollisions(me)
	dmg = 0.5
	if isForm(FORM_NATURE) then
		dmg = 0
	end
	if entity_touchAvatarDamage(me, 48, dmg, 1200) then
		--entity_push(getNaija(), 1200, 1, 0)
	elseif entity_touchAvatarDamage(me, 48, dmg, 1200, 0, 0, -40) then
	elseif entity_touchAvatarDamage(me, 48, dmg, 1200, 0, 0, -80) then
	end
	range = 1024
	size = 1.0
	if entity_isEntityInRange(me, getNaija(), range) then
		dist = entity_getDistanceToEntity(me, getNaija())
		dist = size - (dist/range)*size
		sz = 1 + dist
		entity_scale(me, 1, sz)
	end
end

function damage(me, attacker, bone, damageType, dmg)
	return true
end

function enterState()
end

function exitState()
end

function hitSurface()
end
