dofile("scripts/entities/entityinclude.lua")

n = 0

life = 10

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_NEUTRAL)
	
	entity_setTexture(me, "particles/blow-bubble")
	
	entity_alpha(me, 0.6)
	
	entity_setBlendType(me, BLEND_ADD)

	entity_setState(me, STATE_IDLE)
	
	entity_setWeight(me, -20)
	
	entity_setMaxSpeed(me, 300)
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function pop(me)
	spawnParticleEffect("bubble-release", entity_x(me), entity_y(me))
	spawnParticleEffect("pop-big", entity_x(me), entity_y(me))
	entity_delete(me)
end

function update(me, dt)
	entity_updateMovement(me, dt)
	
	life = life - dt
	if life < 0 then
		pop(me)
		return
	end
	
	if entity_isEntityInRange(me, n, 40) then
		vx = entity_velx(n)
		vy = entity_vely(n)
		if vector_isLength2DIn(vx, vy, 600) then
			-- push
			entity_moveTowardsTarget(me, dt, -500)
		else
			-- pop
			pop(me)
		end
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
	r,g,b = getNoteColor(note)
	entity_setColor(me, r,g,b, 0.2)
end

function songNoteDone(me, note)
end

function song(me, song)
	
end

function activate(me)
end

