dofile("scripts/entities/entityinclude.lua")

n = 0

bubbleSpawnDelay = 2.5
bubbleSpawnTimer = bubbleSpawnDelay

bone = 0

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_ENEMY)
	entity_initSkeletal(me, "beluga")	
	
	entity_setCollideRadius(me, 32)
	--entity_setAllDamageTargets(me, false)
	
	entity_setState(me, STATE_IDLE)
	
	mouth = entity_getBoneByName(me, "mouth")
	
	entity_addVel(me, randVector(300))
	
	entity_setMaxSpeed(me, 100)
	
	entity_setDeathParticleEffect(me, "tinyblueexplode")
	
	entity_setDamageTarget(me, DT_AVATAR_LIZAP, false)
	entity_setDamageTarget(me, DT_AVATAR_PET, false)
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
	entity_updateMovement(me, dt)
	
	entity_doCollisionAvoidance(me, dt, 8, 1)
	
	entity_handleShotCollisions(me)
	
	entity_flipToVel(me)
	
	bubbleSpawnTimer = bubbleSpawnTimer - dt
	
	if bubbleSpawnTimer < 0 then
		bx,by = bone_getWorldPosition(mouth)
		bb = createEntity("beluga-bubble", "", bx, by)
		entity_animate(me, "blowbubble", 0, 1)
		bubbleSpawnTimer = bubbleSpawnDelay
		entity_addVel(bb, entity_velx(me)*0.5, entity_vely(me)*0.5)
		entity_scale(bb, 0, 0)
		entity_scale(bb, 1, 1, 1)
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return true
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

