dofile("scripts/entities/entityinclude.lua")

n = 0
glow = 0

function commonInit(me, skel)
	setupEntity(me)
	entity_setEntityType(me, ET_NEUTRAL)
	entity_initSkeletal(me, skel)
	
	entity_setEntityLayer(me, 1)
	
	entity_setCollideRadius(me, 16)
	entity_setHealth(me, 12)
	
	entity_addVel(me, 1, 0)
	
	entity_setState(me, STATE_IDLE)
	
	off = randRange(1, 100) * 0.002
	entity_scale(me, 1-off, 0.8-off)
	entity_scale(me, 0.8-off, 1-off, 0.5, -1, 1, 1)
	entity_rotate(me, 360, 30, -1)
	
	entity_setCullRadius(me, 128)
	
	glow = entity_getBoneByName(me, "glow")
	bone_setBlendType(glow, BLEND_ADD)
	bone_scale(glow, 10, 10)
	bone_alpha(glow, 0)
	
	entity_setUpdateCull(me, 2000)
	
	entity_setDeathSound(me, "")
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
	
	entity_update(me, randRange(1, 4)*0.1)
end

function commonUpdate(me, dt)
	
	entity_updateCurrents(me, dt)
	entity_updateMovement(me, dt)
	
	entity_doEntityAvoidance(me, dt, 40, 0.1)
	entity_doCollisionAvoidance(me, dt, 8, 0.5)
	
	--entity_handleShotCollisions(me)
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return true
end

function animationKey(me, key)
end

function hitSurface(me)
end
