dofile("scripts/entities/entityinclude.lua")

n = 0
warpBone = 0
coreRots = 0
open = false
doorsDown = 0

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_NEUTRAL)
	entity_initSkeletal(me, "CathedralDoor")	
	entity_setAllDamageTargets(me, false)
	
	entity_generateCollisionMask(me)

	warpBone = entity_getBoneByName(me, "WarpBone")	
	bone_alpha(warpBone, 0)
	
	entity_setState(me, STATE_IDLE)
	
	entity_scale(me, 2, 2)
	
	entity_setCullRadius(me, 1024)
end

function msg(me, msg)
	if msg == "DoorDownPre" or msg=="DoorDown" then
		
		doorsDown = doorsDown + 1
		if doorsDown >= 3 then
			open = true
			voiceOnce("Naija_MithalasDarkness")
		end
		if doorsDown >=1 and doorsDown <=3 then
			tbone = entity_getBoneByIdx(me, doorsDown)
			if msg=="DoorDown" then
				--setCameraLerpDelay(0.5)				
				entity_setInvincible(n, true)
				cam_toEntity(me)
				watch(1)
				clearShots()
				bone_alpha(tbone, 0, 1)
				playSfx("UberVineShrink")
				watch(1)
				bone_alpha(tbone, 0)
				watch(0.5)
				setCameraLerpDelay(0)
				cam_toEntity(n)
				clearShots()
				entity_setInvincible(n, false)
			else
				for i=1,doorsDown do
					tbone = entity_getBoneByIdx(me, i)
					bone_alpha(tbone, 0)
				end
			end
		end
	end
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
	entity_handleShotCollisionsSkeletal(me)
	bone = entity_collideSkeletalVsCircle(me, n)
	if bone ~= 0 then
		nx,ny = entity_getPosition(n)
		cx,cy = entity_getPosition(me)
		x = nx-cx
		y = 0
		x,y = vector_setLength(x,y,2000)
		entity_addVel(n, x, y)
	end
	if open then
		bx,by = bone_getWorldPosition(warpBone)
		if entity_isPositionInRange(n, bx, by, 200) then
			warpNaijaToSceneNode("Cathedral03", "DOORENTER")
		end
	end
	
	entity_updateMovement(me, dt)
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

