dofile("scripts/entities/entityinclude.lua")

n = 0


function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_NEUTRAL)
	entity_initSkeletal(me, "CC")
	entity_setAllDamageTargets(me, false)
	
	entity_scale(me, 0.6, 0.6)
	entity_setBlendType(me, BLEND_ADD)
	entity_alpha(me, 0.5)
	entity_alpha(me, 1, 1, -1, 1, 1)
	
	entity_fh(me)
	entity_setState(me, STATE_IDLE)
end

function postInit(me)
	n = getNaija()
end

done = false
inScene = false
function cutScene(me)
	if inScene then return end
	done = true
	inScene = true
	-- mother arrives, sings song in loop
	entity_idle(n)
	cam_toEntity(me)
	
	watch(2)
	
	setControlHint("You've made it to the end of the final IGF submission of Aquaria!")
	
	watch(5)
	
	clearControlHint()
	
	fade(1, 3)
	watch(3)
	watch(2)
	voice("Naija_LiKidnapped")
	watchForVoice()
	
	fadeOutMusic(4)
	watch(4)
	
	jumpState("Title")
	
	--inScene = false
end

function update(me, dt)
	if entity_isEntityInRange(me, n, 256) then
		cutScene(me)
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "float", -1)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

