dofile("scripts/entities/entityinclude.lua")

n = 0
spawnedEnemies = false
killNode = 0

function init(me)
	setupEntity(me)
	entity_initSkeletal(me, "CC")
	entity_animate(me, "cry", -1)
	
	entity_scale(me, 0.6, 0.6)
end

function spawnEnemies(me)
	if spawnedEnemies then return end
	spawnedEnemies = true
	
	entity_idle(n)
	debugLog("SPAWNENEMIES: START")

	ent = getFirstEntity()
	anEnt = 0
	while ent~=0 do
		if entity_getEntityType(ent) == ET_NEUTRAL and entity_isName(ent, "CC_Kid") then
			anEnt = ent
			entity_animate(ent, "transform")
		end
		ent = getNextEntity()
	end
	
	cam_toEntity(anEnt)
	while entity_isAnimating(anEnt) do
		watch(FRAME_TIME)
	end
	
	iter = 0
	ent = getFirstEntity()
	while ent~=0 do
		if entity_getEntityType(ent) == ET_NEUTRAL and entity_isName(ent, "CC_Kid") then
			createEntity("Scavenger", "", entity_getPosition(ent))
			-- play some special animation for spawning
			entity_delete(ent, 0.5)
		end
		ent = getNextEntity()
	end
	
	cam_toEntity(n)
	
	debugLog("SPAWNENEMIES: END")
	setFlag(FLAG_SUNKENCITY_PUZZLE, 5)
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
	
	if isFlag(FLAG_SUNKENCITY_PUZZLE, 5) then
		spawnEnemies(me)
	elseif isFlag(FLAG_SUNKENCITY_PUZZLE, 6) then
		spawnedEnemies = true
	end
	
	killNode = getNode("KILL")
end

function update(me, dt)
	if entity_isState(me, STATE_IDLE) then
		if isFlag(FLAG_SUNKENCITY_PUZZLE, 5) then
			num = node_getNumEntitiesIn(killNode, "Scavenger")
			
			if num < 1 then
				setFlag(FLAG_SUNKENCITY_PUZZLE, 6)
				debugLog(msg("You beat the enemies!!!"))
			end
		else
			if not spawnedEnemies then
				if entity_isEntityInRange(me, n, 128) then
					spawnEnemies(me)
				end
			end
		end
	elseif entity_isState(me, STATE_DONE) then
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "cry", -1)
		entity_setPosition(me, entity_getPosition(me))
	elseif entity_isState(me, STATE_FOLLOW) then
		entity_animate(me, "float", -1)	
	elseif entity_isState(me, STATE_DONE) then
		
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

