dofile("scripts/entities/entityinclude.lua")

--crying in house
n = 0
curNote = 1
notes = { 1, 3, 4, 5, 1, 3, 4, 2, 1, 3, 4, 0 }

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_NEUTRAL)
	entity_initSkeletal(me, "CC")	
	entity_setAllDamageTargets(me, false)
		
	entity_scale(me, 0.5, 0.5)
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)

	if isFlag(FLAG_SUNKENCITY_BOSS, 1) then
		entity_delete(me)
	elseif getFlag(FLAG_SUNKENCITY_PUZZLE) > 1 then
		gfNode = getNode("GFGARDEN")
		gf = createEntity("CC_GF", "", node_x(gfNode), node_y(gfNode))
		entity_delete(me)
	else
		entity_setState(me, STATE_IDLE)
	end	
end

done = false
inScene = false
function cutScene(me)
	if inScene then return end
	done = true
	inScene = true
	-- mother arrives, sings song in loop
	msg("You sang the song!")
	entity_idle(n)
	cam_toEntity(me)
	watch(1)
	-- girlfriend shows up
	
	gfNode = getNode("GFAPPEAR")
	gf = createEntity("CC_GF", "", node_x(gfNode), node_y(gfNode))
	cam_toEntity(gf)
	entity_alpha(gf, 0)
	entity_alpha(gf, 1, 2)
	watch(2)
	entity_moveToNode(gf, getNode("GFGARDEN"), SPEED_NORMAL)
	entity_animate(gf, "float", -1)
	entity_watchForPath(gf)
	entity_animate(gf, "idle", -1)
	watch(1)
	cam_toEntity(n)
	
	setFlag(FLAG_SUNKENCITY_PUZZLE, 2)
	cam_toEntity(n)
	
	entity_delete(me)
	
	inScene = false
end

function update(me, dt)
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "cry", -1)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
	if isFlag(FLAG_SUNKENCITY_PUZZLE, 1) then
		if notes[curNote] == note then
			debugLog("note match")
			curNote = curNote + 1
			if curNote >= 13 then
				cutScene(me)
			end
		else
			debugLog("note fail")
			curNote = 1
		end
	end
end

function song(me, song)
end

function activate(me)
end

