-- ================================================================================================
-- C H O M P E R
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")

-- ================================================================================================
-- L O C A L   V A R I A B L E S 
-- ================================================================================================

startX = 0
startY = 0
startRot = 0

dir = 0

biteDelay = 0
bD = 1.67	-- Time before bite
doneDelay = 0		
dD = 1.32	-- Time after bite

maxSpeed = 890

-- ================================================================================================
-- F U N C T I O N S
-- ================================================================================================

function init(me)
	setupBasicEntity(
	me,
	"Chomper/Body",					-- texture
	14,								-- health
	1,								-- manaballamount
	1,								-- exp
	1,								-- money
	64,								-- collideRadius (only used if hit entities is on)
	STATE_IDLE,						-- initState
	256,							-- sprite width	
	256,							-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	0,								-- 0/1 hit other entities off/on (uses collideRadius)
	1800							-- updateCull -1: disabled, default: 4000
	)
	
	entity_setDeathParticleEffect(me, "Explode")
	entity_setDropChance(me, 11)
	
	entity_initSkeletal(me, "Chomper")
	glow = entity_getBoneByName(me, "EyeGlow")
	body = entity_getBoneByName(me, "Body")
	
	entity_setEntityType(me, ET_ENEMY)
	entity_generateCollisionMask(me)
	
	entity_setCullRadius(me, 420) -- Skeletal sprites ain't got auto cull yet (says Alec)
	
	bone_alpha(glow, 0.21)
	bone_scale(glow, 0.12, 0.12)
	
	entity_setMaxSpeed(me, maxSpeed)
	
	entity_initEmitter(me, 0, "ChomperLunge")
end

function postInit(me)
	entity_setState(me, STATE_IDLE)
	startX, startY = entity_getPosition(me)
	startRot = entity_getRotation(me)
	
	-- FLIP HORIZONTALLY IF THERE'S A FLIP NODE
	node = entity_getNearestNode(me, "FLIP")
	if node ~=0 then
		if node_isEntityIn(node, me) then 
			entity_fh(me)
			dir = 1
		end
	end
end

function update(me, dt)
	-- SET TARGET TO BODY
	entity_clearTargetPoints(me)
	x,y = bone_getWorldPosition(body)
	entity_addTargetPoint(me, x, y)
	
	entity_findTarget(me, 808)
	
	if not entity_hasTarget(me) then
		bone_alpha(glow, 0.21, 0.89)
		bone_scale(glow, 0.12, 0.12, 0.89)
		
		biteDelay = bD
	else
		bone_alpha(glow, 0.89, 0.26)
		bone_scale(glow, 1, 1, 0.26)
		
		if entity_getState(me) == STATE_OPEN then
			bone_alpha(glow, 0.93, 0.64)
			bone_scale(glow, 1.8, 1.8, 0.56)
			-- Aim a bit before bite
			entity_rotateToEntity(me, getNaija(), 2.8, 90 +(dir*-180))
		end
		
		-- TIME BETWEEN BITES
		if biteDelay > 0 then biteDelay = biteDelay - dt
		else biteDelay = 0 end
		
		if biteDelay == 0 then
			if entity_isState(me, STATE_IDLE) then entity_setState(me, STATE_OPEN) end
			biteDelay = bD
		end
	end
	
	-- WAIT A MOMENT BEFORE RETURNING TO START POSITION
	if entity_getState(me) == STATE_DONE then
		if doneDelay > 0 then doneDelay = doneDelay - dt
		else doneDelay = 0 end
		
		if doneDelay == 0 then entity_setState(me, STATE_CLOSE) end
	end

	-- DON'T UPDATE MOVEMENT IF CHOMPER'S SLIDING BACK TO HOME POSITION
	if entity_getState(me) == STATE_CLOSE then
		closeX, closeY = entity_getPosition(me)
		
		if closeX == startX and closeY == startY then
			entity_setState(me, STATE_IDLE)
		end
	else
		-- UPDATE MOVEMENT
		entity_doFriction(me, dt, 654)
		entity_updateMovement(me, dt)
	end
	
	-- UPDATE COLLISIONS
	if entity_getState(me) == STATE_ATTACK then entity_touchAvatarDamage(me, 124, 3.2, 1337)
	else entity_touchAvatarDamage(me, 98, 1.2, 789)  end	-- Could make skeletal as well...
	entity_handleShotCollisionsSkeletal(me)
end

function enterState(me)
	if entity_getState(me) == STATE_IDLE then
		entity_animate(me, "idle", LOOP_INF)
		biteDelay = bD
		entity_clearVel(me)
		entity_setMaxSpeed(me, 0)
		
	elseif entity_getState(me) == STATE_OPEN then
		entity_setStateTime(me, entity_animate(me, "open"))
		entity_setNaijaReaction(me, "shock")
		
	elseif entity_getState(me) == STATE_ATTACK then
		entity_setStateTime(me, entity_animate(me, "attack"))
		entity_setMaxSpeed(me, maxSpeed)
		entity_setMaxSpeedLerp(me, 7.9)				-- Increased biteyness
		entity_setMaxSpeedLerp(me, 0.76, 0.38)
	
	elseif entity_getState(me) == STATE_DONE then
		entity_animate(me, "idle", LOOP_INF)
		entity_rotateTo(me, startRot, 3.21)
		
	elseif entity_getState(me) == STATE_CLOSE then
		-- Go back home, Chomper!
		entity_setPosition(me, startX, startY, 2, 0, 0, 1)
	end
end

function animationKey(me, key)
	if entity_getState(me) == STATE_ATTACK and key == 0 then
		entity_sound(me, "Bite", 543 + math.random(123))
		
		-- THRUST IN PROPER DIRECTION
		if dir == 0 then
			thrustX, thrustY = entity_getAimVector(me, 270, (maxSpeed*10), 0)
			entity_addVel(me, thrustX, thrustY)
		else
			thrustX, thrustY = entity_getAimVector(me, 270, (maxSpeed*10), 1)
			entity_addVel(me, thrustX, thrustY)
		end
		
		spawnParticleEffect("ChomperLunge", entity_x(me), entity_y(me))
		entity_startEmitter(me, 0)
		shakeCamera(3.2, 0.54)
	end
end

function exitState(me)
	if entity_getState(me) == STATE_OPEN then
		entity_setState(me, STATE_ATTACK)
	
	elseif entity_getState(me) == STATE_ATTACK then
		entity_setState(me, STATE_DONE)
		doneDelay = dD
		entity_stopEmitter(me, 0)
	end
end

function damage(me, attacker, bone, damageType, dmg)
	if bone == body then
		return true
	end
	
	return false
end

function dieNormal(me)
	if chance(75) then
		spawnIngredient("SpicyMeat", entity_x(me), entity_y(me))
	end
end

