-- ================================================================================================
-- K I N G   C R A B
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")


-- ================================================================================================
-- L O C A L  V A R I A B L E S 
-- ================================================================================================

fireDelay = 3
moveTimer = 0

STATE_FIRING = 1001
STATE_CLAW	 = 1002

leftArm = 0
claw = 0

cannon = 0
n=0

-- ================================================================================================
-- FUNCTIONS
-- ================================================================================================

function init(me)
	setupBasicEntity(me, 
	"",								-- texture
	12,								-- health
	2,								-- manaballamount
	2,								-- exp
	1,								-- money
	32,								-- collideRadius (for hitting entities + spells)
	STATE_IDLE,						-- initState
	256,							-- sprite width	
	256,							-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	1,								-- 0/1 hit other entities off/on (uses collideRadius)
	2500							-- updateCull -1: disabled, default: 4000
	)
	
	entity_initSkeletal(me, "ClockworkCrab")
	
	entity_setDeathParticleEffect(me, "TinyRedExplode")
	entity_clampToSurface(me)
	
	cannon = entity_getBoneByName(me, "Cannon")
	leftArm = entity_getBoneByName(me, "LeftArm")
	claw = entity_getBoneByName(me, "Claw")
	
	entity_setState(me, STATE_IDLE)	
	n = getNaija()
	entity_setCullRadius(me, 1024)
	
	entity_setDamageTarget(me, DT_AVATAR_BITE, false)
end

function postInit(me)
	n = getNaija()
end

function animationKey(me, key)
	if entity_isState(me, STATE_FIRING) and key == 1 then
		x, y = bone_getWorldPosition(cannon)
		nx, ny = getWallNormal(entity_getPosition(me))
		if entity_hasTarget(me) then
			createShot("ClockworkCrab", me, entity_getTarget(me), x, y)			
		end
	end
end

function update(me, dt)
	if entity_touchAvatarDamage(me, entity_getCollideRadius(me), 1, 1000) then
	end
	
	entity_handleShotCollisions(me)
	
	if entity_isState(me, STATE_IDLE) then
		entity_moveAlongSurface(me, dt, 200, 6, 10)
		entity_rotateToSurfaceNormal(me, 0.1)
		moveTimer = moveTimer + dt
		if moveTimer > 30 then
			entity_switchSurfaceDirection(me)
			moveTimer = 0
		end
	elseif entity_isState(me, STATE_CLAW) then
		x1,y1 = bone_getWorldPosition(leftArm)
		x2,y2 = bone_getWorldPosition(claw)
		if entity_collideCircleVsLine(n, x1, y1, x2, y2, 8) then
			entity_damage(n, me, 1)
		end
	end
	

	if not(entity_hasTarget(me)) then
		entity_findTarget(me, 1200)
	else
		if entity_isState(me, STATE_IDLE) then
			if fireDelay > 0 then
				fireDelay = fireDelay - dt
				if fireDelay < 0 then
					-- dmg, mxspd, homing, numsegs, out
					--entity_fireAtTarget(me, "BlasterFire", 1, 400, 200, 3, 64)
					--s = createShot("ClockworkCrab", me, entity_getTarget(me), bone_getPosition(cannon))					
					fireDelay = 4
					if chance(50) then
						entity_setState(me, STATE_FIRING)
					else
						entity_setState(me, STATE_CLAW)
					end
				end
			end
		end
	end
	
	if isObstructed(entity_x(me), entity_y(me)) then
		entity_adjustPositionBySurfaceNormal(me, 1)
	end
end

function enterState(me)
	if entity_getState(me)==STATE_IDLE then
		entity_animate(me, "idle", -1)
	elseif entity_isState(me, STATE_FIRING) then
		entity_setStateTime(me, entity_animate(me, "firing", 10))
	elseif entity_isState(me, STATE_CLAW) then
		entity_setStateTime(me, entity_animate(me, "claw"))
	elseif entity_isState(me, STATE_DEAD) then
		entity_sound(me, "MetalExplode", math.random(100)+750)
		spawnParticleEffect("ClockworkCrabDie", entity_getPosition(me))
	end
end

function exitState(me)
	if entity_isState(me, STATE_FIRING) or entity_isState(me, STATE_CLAW) then
		entity_setState(me, STATE_IDLE)
	end
end

function hitSurface()
end

function damage(me, attacker, bone, damageType, dmg)
	return true
end
