-- ================================================================================================
-- C R E E P Y   F A C E
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")

-- ================================================================================================
-- L O C A L   V A R I A B L E S
-- ================================================================================================

faceTimer = 1.23 + (math.random(123) * 0.1)
 
-- ================================================================================================
-- F U N C T I O N S
-- ================================================================================================

function init(me)
	setupBasicEntity(
	me,
	"CreepyFace/Face",				-- texture
	69,								-- health
	69,								-- manaballamount
	69,								-- exp
	69,								-- money
	69,								-- collideRadius (only used if hit entities is on)
	STATE_IDLE,						-- initState
	256,							-- sprite width	
	256,							-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	0,								-- 0/1 hit other entities off/on (uses collideRadius)
	1234							-- updateCull -1: disabled, default: 4000
	)
	
	entity_setAllDamageTargets(me, false)
	
	entity_setState(me, STATE_IDLE)
end

function postInit(me)
	entity_alpha(me, 0)
end

function update(me, dt)
	if faceTimer > 0 then faceTimer = faceTimer - dt
	elseif faceTimer <= 0 then
		faceTimer = 1.23 + (math.random(123) * 0.1)
		
		spawnParticleEffect("CreepyFace", entity_x(me), entity_y(me))
	end
end

function enterState(me)
	if entity_getState(me) == STATE_IDLE then
	end
end

function damage(me, attacker, bone, damageType, dmg, x, y)
	return false
end

function exitState(me)
end
