dofile("scripts/entities/entityinclude.lua")

n = 0

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_ENEMY)
	--entity_initSkeletal(me, "SkeletalFile")	
	entity_setAllDamageTargets(me, false)
	
	--entity_generateCollisionMask(me)
	
	entity_setCollideRadius(me, 32)
	
	entity_setState(me, STATE_IDLE)
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
	if entity_isState(me, STATE_GROW) then
	else
		entity_updateMovement(me, dt)
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
	elseif entity_isState(me, STATE_GROW) then
		entity_scale(me, 0.2, 0.2)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

function msg(me, msg)
	if msg == "g" then
		sx, sy = entity_getScale(me)
		entity_scale(me, sx+0.1, sy+0.1, 0.5)
	end
end
