dofile("scripts/entities/entityinclude.lua")

n = 0

STATE_SHAKE = 1001

bone_head = 0

function init(me)
	setupEntity(me)
	entity_setEntityLayer(me, -2)
	--entity_setEntityType(me, ET_ENEMY)
	entity_initSkeletal(me, "Dandelion")	
	entity_setAllDamageTargets(me, false)	
	entity_setCullRadius(me, 1024)	
	entity_generateCollisionMask(me)
	
	entity_setState(me, STATE_IDLE)
	bone_head = entity_getBoneByName(me, "Head")
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
	if entity_isState(me, STATE_IDLE) then
		--entity_handleShotCollisionsSkeletal(me)
		bone = entity_collideSkeletalVsCircle(me, n)
		if bone ~= 0 and avatar_isBursting() then
			-- shake!
			entity_setState(me, STATE_SHAKE)
		end
	end
	entity_updateMovement(me, dt)
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
	elseif entity_isState(me, STATE_SHAKE) then
		entity_setStateTime(me, entity_animate(me, "shake"))
	end
end

function exitState(me)
	if entity_isState(me, STATE_SHAKE) then
		-- spawn spore seeds
		x, y = bone_getWorldPosition(bone_head)
		createEntity("SeedFlower", "", x, y)
		entity_setState(me, STATE_IDLE)
	end
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

