-- DARK JELLY

dofile("scripts/entities/entityinclude.lua")

blupTimer = 0
dirTimer = 0
blupTime = 3.0

sz = 1.0
dir = 0

MOVE_STATE_UP = 0
MOVE_STATE_DOWN = 1
MOVE_STATE_AWAY = 2

moveState = 0
moveTimer = 0
velx = 0
waveDir = 1
waveTimer = 0
soundDelay = 0
glows = {}

n = 0

seen = false

function doIdleScale(me)
	entity_scale(me, 1*sz, 1.05*sz)
	entity_scale(me, 1.1*sz, 0.95*sz, blupTime, -1, 1, 1)
end

function init(me)
	setupBasicEntity(
	me,
	"",								-- texture
	60,								-- health
	2,								-- manaballamount
	2,								-- exp
	10,								-- money
	0,								-- collideRadius (for hitting entities + spells)
	STATE_IDLE,						-- initState
	128,							-- sprite width	
	128,							-- sprite height
	1,								-- particle "explosion" type, 0 = none
	0,								-- 0/1 hit other entities off/on (uses collideRadius)
	4000,							-- updateCull -1: disabled, default: 4000
	0
	)
	
	entity_initSkeletal(me, "DarkJelly", "DarkJellyFG")
	
	entity_setEntityType(me, ET_NEUTRAL)
	entity_setDamageTarget(me, false)
	
	entity_setEntityLayer(me, 0)
		
	--entity_initHair(me, 64, 16, 128, "DarkJelly/Tentacles")
	
	
	doIdleScale(me)
	
	entity_exertHairForce(me, 0, 400, 1)
		
	entity_setState(me, STATE_IDLE)
	--entity_setCullRadius(me, -3)
	entity_setCull(me, false)
	
	bone_setSegs(entity_getBoneByName(me, "Tentacles"), 4, 32, 0.6, 0.6, -0.028, 0, 0.75, 0)
	
	--[[
	for i=1,4 do
		glows[i] = entity_getBoneByName(me, string.format("Glow%d", i))
		bone_alpha(glows[i], 0.5)
		bone_alpha(glows[i], 1, 1, -1, 1, 1)
		bone_update(glows[i], i*0.25)
	end
	]]--
	
	entity_setCollideRadius(me, 160)
	
	entity_setInternalOffset(me, 0, 64)
	
	entity_generateCollisionMask(me)
	
end

function postInit(me)
	entity_update(me, math.random(100)/100.0)
	n = getNaija()
end

function update(me, dt)
	--dt = dt * 1.5
	sx,sy = entity_getScale(me)
		
	moveTimer = moveTimer - dt
	if moveTimer < 0 then
		if moveState == MOVE_STATE_DOWN then		
			moveState = MOVE_STATE_UP
			entity_setMaxSpeedLerp(me, 1.5, 0.2)
			--entity_scale(me, 0.75, 1, 1, 1, 1)
			moveTimer = 3 + math.random(200)/100.0
			--entity_sound(me, "JellyBlup")
		elseif moveState == MOVE_STATE_UP then
			velx = math.random(400)+100
			if math.random(2) == 1 then
				velx = -velx
			end
			moveState = MOVE_STATE_DOWN
			entity_setMaxSpeedLerp(me, 1, 1)
			moveTimer = 5 + math.random(200)/100.0 + math.random(3)
		else
			moveState = MOVE_STATE_DOWN
		end
	end
	
	waveTimer = waveTimer + dt
	if waveTimer > 2 then
		waveTimer = 0
		if waveDir == 1 then
			waveDir = -1
		else
			waveDir = 1
		end
	end

	if moveState == MOVE_STATE_UP then
		entity_addVel(me, velx*dt, -600*dt)
		entity_rotateToVel(me, 8)
		
	elseif moveState == MOVE_STATE_DOWN then
		entity_addVel(me, 0, 50*dt)
		entity_rotateTo(me, 0, 8)
		entity_exertHairForce(me, 0, 200, dt*0.6, -1)
		entity_doCollisionAvoidance(me, dt, 15, 1)
		--entity_doCollisionAvoidance(me, dt, 10, 0.5)
	elseif moveState == MOVE_STATE_AWAY then
		entity_rotateTo(me, 0, 8)
	end

	entity_doCollisionAvoidance(me, dt, 12, 2)
	--[[
	entity_doEntityAvoidance(me, dt, 32, 1.0)
	entity_doCollisionAvoidance(me, 1.0, 8, 1.0)
	entity_updateCurrents(me, dt)
	]]--
	entity_updateMovement(me, dt)
	
	entity_handleShotCollisions(me)
	
	if entity_touchAvatarDamage(me, entity_getCollideRadius(me), 0) then
		if avatar_isBursting() and entity_setBoneLock(n, me) then
			-- yay!
		else
			x, y = entity_getVectorToEntity(me, n, 1000)
			entity_addVel(n, x, y)
		end
	end
	
	if not seen and entity_isEntityInRange(me, n, 512) then
		emote(EMOTE_NAIJAWOW)
		seen = true
	end
	
	
	--[[
	bx, by = bone_getWorldPosition(entity_getBonyByIdx(me, 0))
	entity_setHairHeadPosition(me, bx, by)
	entity_updateHair(me, dt*5)
	]]--
end

function hitSurface(me)
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_setMaxSpeed(me, 40)
		entity_animate(me, "idle", LOOP_INF)
	end
end

function damage(me, attacker, bone, damageType, dmg, hx, hy)
	if entity_getBoneLockEntity(n) == me then
		if chance(25) then
			if chance(50) then
				emote(EMOTE_NAIJALAUGH)
			else
				emote(EMOTE_NAIJAGIGGLE)
			end
		end
	end
	entity_setHealth(me, 60)
	entity_setMaxSpeedLerp(me, 10)
	entity_setMaxSpeedLerp(me, 1, 10)
	
	moveState = MOVE_STATE_AWAY
	vx = entity_x(me) - hx
	vy = entity_y(me) - hy
	vx, vy = vector_setLength(vx, vy, 400)
	entity_addVel(me, vx, vy)
	
	entity_rotateToVel(me, 2)
	return true
end

function exitState(me)
end
