-- ================================================================================================
-- EEL
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")

-- ================================================================================================
-- FUNCTIONS
-- ================================================================================================

dir = 0
switchDirDelay = 0
wiggleTime = 0
wiggleDir = 1
interestTimer = 0
colorRevertTimer = 0

collisionSegs = 32
avoidLerp = 0
avoidDir = 1
glow = 0
glowBone = 0

function init(me)
-- oldhealth : 40
	setupBasicEntity(
	me,
	"",						-- texture
	6,								-- health
	1,								-- manaballamount
	1,								-- exp
	1,								-- money
	32,								-- collideRadius (only used if hit entities is on)
	STATE_IDLE,						-- initState
	90,								-- sprite width
	90,								-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	0,								-- 0/1 hit other entities off/on (uses collideRadius)
	2500							-- updateCull -1: disabled, default: 4000
	)
	
	entity_setDropChance(me, 50)
	
	lungeDelay = 1.0				-- prevent the nautilus from attacking right away

	entity_initHair(me, 64, 8, 32, "DeepEel/Tail")
	
	entity_initSkeletal(me, "DeepEel")

	n = getNaija()
	entity_setTarget(me, n)
	
	entity_addVel(me, math.random(1000)-500, math.random(1000)-500)
	entity_setDeathParticleEffect(me, "TinyBlueExplode")
	
	entity_setState(me, STATE_IDLE)
	
	entity_setDeathScene(me, true)
	
	glow = createQuad("Naija/LightFormGlow", 13)
	quad_scale(glow, 1.5, 1.5)
	--quad_scale(glow, 1.8, 1.8, 1, -1, 1, 1)
	glowBone = entity_getBoneByName(me, "Glow")	
end

function dieNormal(me)
	if chance(5) then
		spawnIngredient("GlowingEgg", entity_x(me), entity_y(me))
	end
end

function update(me, dt)
	
	if entity_getState(me)==STATE_IDLE then
		if entity_isEntityInRange(me, n, 800) then
			entity_moveTowardsTarget(me, dt, 500)
			entity_setMaxSpeedLerp(me, 0.8, 0.5)
		else
			entity_setMaxSpeedLerp(me, 1, 0.8)
		end
		
		entity_doEntityAvoidance(me, dt, 32, 0.1)
		entity_doCollisionAvoidance(me, dt, 10, 0.1)
		entity_doCollisionAvoidance(me, dt, 4, 0.8)
	end
	entity_updateMovement(me, dt)	
	entity_setHairHeadPosition(me, entity_x(me), entity_y(me))
	entity_updateHair(me, dt)
	entity_handleShotCollisionsHair(me, collisionSegs)
	--entity_handleShotCollisions(me)
	if entity_collideHairVsCircle(me, n, collisionSegs) then
		entity_touchAvatarDamage(me, 0, 0.5, 500)
	end
	entity_rotateToVel(me)
	entity_flipToVel(me)
	
	quad_setPosition(glow, bone_getWorldPosition(glowBone))
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_setMaxSpeed(me, 600)
		entity_animate(me, "idle", -1)
	elseif entity_isState(me, STATE_DEATHSCENE) then
		entity_clearVel(me)
		entity_setStateTime(me, 1.5)
		for i=32,1,-6 do
			x, y = entity_getHairPosition(me, i)
			spawnParticleEffect("TinyBlueExplode", x, y, 0.2*((32-i)/6.0))
		end
	elseif entity_isState(me, STATE_DEAD) then
		quad_delete(glow)
	end
end

function exitState(me)
end

function hitSurface(me)
end

function damage(me, attacker, bone, damageType, dmg)
	entity_setMaxSpeedLerp(me, 3)
	entity_setMaxSpeedLerp(me, 1,2)

	return true
end

function songNote(me, note)
end
