dofile("scripts/entities/entityinclude.lua")

n = 0
glow = 0
boneGlow = 0
dir = 1
dirTimer = 0

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_ENEMY)
	entity_initSkeletal(me, "DeepUrchin")
	
	entity_setHealth(me, 12)
	
	entity_setAllDamageTargets(me, false)
	
	entity_setCollideRadius(me, 80)
	
	entity_setState(me, STATE_IDLE)
	
	boneGlow = entity_getBoneByName(me, "Glow")
	glow = createQuad("Naija/LightFormGlow", 13)
	quad_scale(glow, 8, 8)
	quad_alpha(glow, 0)
	entity_setDamageTarget(me, DT_AVATAR_ENERGYBLAST, true)
	entity_setDamageTarget(me, DT_AVATAR_SHOCK, true)
	entity_setUpdateCull(me, 3000)
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
	entity_handleShotCollisions(me)
	if entity_touchAvatarDamage(me, entity_getCollideRadius(me), 1, 800) then		
	end
	
	dirTimer = dirTimer + dt
	if dirTimer > 3 then
		dirTimer = 0
		dir = -dir
	end
	
	entity_addVel(me, 1000*dt*dir, 0)
	
	entity_updateMovement(me, dt)
	quad_setPosition(glow, entity_getPosition(me))
	
	
	
	if entity_isEntityInRange(me, n, 256) then
		quad_alpha(glow, 1, 0.8)
		bone_alpha(boneGlow, 1, 0.8)
	else
		quad_alpha(glow, 0, 0.3)
		bone_alpha(boneGlow, 0, 0.3)
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
	elseif entity_isState(me, STATE_DEAD) then
		quad_delete(glow)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg, x, y)
	if damageType == DT_AVATAR_SHOCK then
		x,y = entity_getPosition(n)
	end
	if damageType == DT_AVATAR_ENERGYBLAST or damageType == DT_AVATAR_SHOCK then
		if y > entity_y(me) + 50 and x > entity_x(me)-32 and x < entity_x(me)+32 then
			return true
		end
	end
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

