dofile("scripts/entities/entityinclude.lua")

n = 0
seen = false

notes = { 4, 2, 3, 2, 1 }
numNotes = 5
curNote = 1

warpLoc = 0

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_NEUTRAL)
	entity_initSkeletal(me, "DeepWhale")
	
	entity_scale(me, 1.5, 1.5)
	
	
	entity_setCullRadius(me, 3500)
	if isFlag(FLAG_DEEPWHALE, 0) then
		entity_setState(me, STATE_IDLE)
	else
		entity_setState(me, STATE_OPENED)
	end
	warpLoc = entity_getBoneByName(me, "WarpLoc")
	
	loadSound("DeepWhale-Open")
	
	entity_setInternalOffset(me, 0, -50)
	entity_setInternalOffset(me, 0, 50, 4, -1, 1, 1)
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
	if entity_isState(me, STATE_OPENED) then
		--debugLog("opened")
		bx, by = bone_getWorldPosition(warpLoc)
		if entity_isPositionInRange(n, bx, by, 200) then
			loadMap("WHALE", "ENTER")
		end
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
	elseif entity_isState(me, STATE_OPEN) then
		playSfx("DeepWhale-Open")
		seen = true
		entity_idle(n)
		entity_animate(me, "open")
		shakeCamera(10, 4)
		entity_flipToEntity(n, me)
		watch(1)
		emote(EMOTE_NAIJAUGH)
		watch(2)
		emote(EMOTE_NAIJAWOW)
		watch(2)
		emote(EMOTE_NAIJAGIGGLE)
		entity_setStateTime(me, 1)
	elseif entity_isState(me, STATE_OPENED) then
		entity_animate(me, "opened", -1)
		if isFlag(FLAG_DEEPWHALE, 0) then
			setFlag(FLAG_DEEPWHALE, 1)
		end
	end
end

function exitState(me)
	if entity_isState(me, STATE_OPEN) then
		entity_setState(me, STATE_OPENED)
	end
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function lightFlare(me)
	if not seen then
		if entity_isEntityInRange(me, n, 600) then
			entity_idle(n)
			seen = true
			entity_flipToEntity(n, me)
			watch(0.2)
			emote(EMOTE_NAIJAUGH)
			watch(1.4)
			emote(EMOTE_NAIJALAUGH)
		end
	end
end

function songNote(me, note)

end

function songNoteDone(me, note)
	if entity_isState(me, STATE_IDLE) then
		debugLog(string.format("curNote: %d", curNote))
		if notes[curNote] == note then
			curNote = curNote + 1
		else
			curNote = 1
		end
		if curNote > numNotes then
			entity_setState(me, STATE_OPEN)
		end
	end
end

function song(me, song)
end

function activate(me)
end

