dofile("scripts/entities/entityinclude.lua")

n = 0

anim = "idle"

function init(me)
	setupEntity(me)
	entity_initSkeletal(me, "Druniad")	
	
	entity_setCullRadius(me, 2048)
	entity_setState(me, STATE_IDLE)
	
	entity_scale(me, 0.7, 0.7)
	
	--loadSound("DruniadDie")
end

function postInit(me)
	node = entity_getNearestNode(me, "SIT")
	if node ~= 0 and node_isEntityIn(node, me) then
		anim = "sit"
	end
	
	node = entity_getNearestNode(me, "PET")
	if node ~= 0 and node_isEntityIn(node, me) then
		anim = "pet"
	end
	
	node = entity_getNearestNode(me, "FLIP")
	if node ~= 0 and node_isEntityIn(node, me) then
		entity_fh(me)
	end
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, anim, -1)
	elseif entity_isState(me, STATE_DONE) then
		spawnParticleEffect("TinyGreenExplode", entity_getPosition(me))
		spawnParticleEffect("LeafExplode", entity_getPosition(me))
		entity_alpha(me, 0)
		--entity_soundFreq(me, "DruniadDie", math.random(500)/500 + 0.75)
		--playSfx("DruniadDie")
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

