-- generic egg
dofile("scripts/entities/entityinclude.lua")

STATE_HATCH		= 1000

function init()
	setupConversationEntity("egg")
	entity_setActivationType(AT_NONE)
	entity_setEntityType(ET_NEUTRAL)
end

function hatch()
	entity_stopTimer()	
	if entity_getState()==STATE_IDLE then
		entity_createEntity(entityTypeName)
	elseif entity_getState()==STATE_PLANTED then
		entity_createPet(entityTypeName)
	end
	entity_delete()
	entity_setState(STATE_HATCH)
end

function exitTimer()
	hatch()
end

function update()
	if entity_getState()==STATE_IDLE then
		if not entity_hasTarget() then
			entity_findTarget(800)
		else
			if entity_isTargetInRange(64) then
				pickupItem(itemName, 1)
				entity_delete()
			end
		end
	end
end

function enterState()
	if entity_getState()==STATE_PLANTED then
		entity_resetTimer(plantedTime)
	elseif entity_getState()==STATE_IDLE then
		entity_resetTimer(hatchTime)
	end
end

function exitState()
end

function activate()
end

function hitSurface()
end