-- ================================================================================================
-- E C C O
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")

-- ================================================================================================
-- L O C A L   V A R I A B L E S
-- ================================================================================================

dir = 0
switchDirDelay = 0
wiggleTime = 0
wiggleDir = 1
interestTimer = 0
colorRevertTimer = 0

collisionSegs = 50
avoidLerp = 0
avoidDir = 1
interest = false

jumpDelay = 0

n = 0

-- ================================================================================================
-- F U N C T I O N S
-- ================================================================================================

function init(me)
-- oldhealth : 40
	setupBasicEntity(
	me,
	"",						-- texture
	12,								-- health
	1,								-- manaballamount
	1,								-- exp
	1,								-- money
	32,								-- collideRadius (only used if hit entities is on)
	STATE_IDLE,						-- initState
	90,								-- sprite width
	90,								-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	0,								-- 0/1 hit other entities off/on (uses collideRadius)
	-1							-- updateCull -1: disabled, default: 4000
	)
	
	entity_setDropChance(me, 50)
	
	lungeDelay = 1.0				-- prevent the nautilus from attacking right away
	
	if chance(50) then
		dir = 0
	else
		dir = 1
	end
	
	if chance(50) then
		interest = true
	end
	switchDirDelay = math.random(800)/100.0
	naija = getNaija()
	
	entity_addVel(me, math.random(1000)-500, math.random(1000)-500)
	entity_setDeathParticleEffect(me, "TinyRedExplode")
	
	entity_initSkeletal(me, "ekko")
	body = entity_getBoneByName(me, "Body")
	bone_setSegs(body, 8, 8, 0.69, 0.23, 0, -0.03, 8, 0)
	
	entity_setCanLeaveWater(me, true)
	entity_scale(me, 0.75, 0.75)
	
	entity_setDamageTarget(me, DT_AVATAR_LIZAP, false)
	
	entity_setState(me, STATE_IDLE)
	
	entity_setDamageTarget(me, DT_AVATAR_LIZAP, false)
	entity_setDamageTarget(me, DT_AVATAR_PET, false)
end

function postInit(me)
	n = getNaija()
end

-- the entity's main update function
function update(me, dt)
	if entity_getState(me)==STATE_IDLE then		
		entity_doCollisionAvoidance(me, dt, 10, 0.1)
		entity_doCollisionAvoidance(me, dt, 4, 0.5)
	end

	if not entity_hasTarget(me) then
		entity_findTarget(me, 500)
	else
		-- has target
		if entity_isUnderWater(me) then
			if not entity_isNearObstruction(entity_getTarget(me), 5) then
				if interest then
					entity_moveTowardsTarget(me, dt, 500)
				end
			end
		end
	end
	entity_flipToVel(me)
	entity_rotateToVel(me, 0.3)
	entity_updateCurrents(me, dt)
	entity_updateMovement(me, dt)	
	
	if entity_isUnderWater(me) then
		jumpDelay = jumpDelay - dt
		if jumpDelay <= 0 then
			jumpDelay = 0
			entity_setCanLeaveWater(me, true)
			if entity_y(me) - getWaterLevel() < 400 then
				entity_addVel(me, 0, -1000*dt)
			end
		end
		interestTimer = interestTimer + dt
		if interestTimer > 12 then
			if interest then
				interest = false
			else
				interest = true
			end
			interestTimer = math.random(3)
		end
	end
	if entity_checkSplash(me) then
		if not entity_isUnderWater(me) then
			entity_setMaxSpeedLerp(me, 2)
			
			if entity_velx(me) < 0 then
				entity_addVel(me, -200, -456)
			else
				entity_addVel(me, 200, -456)
			end
			entity_setWeight(me, 888)
			jumpDelay = 2+math.random(5)
		else
			entity_setCanLeaveWater(me, false)
			entity_setWeight(me, 0)
		end
	end
	
	-- COLLISIONS
	entity_handleShotCollisions(me)
	
	if entity_touchAvatarDamage(me, 64, 0) then
		--[[
		if avatar_isBursting() and entity_setBoneLock(n, me) then
		else
		]]--
			x, y = entity_getVectorToEntity(me, n, 420)
			entity_addVel(n, x, y)
		--end
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", LOOP_INF)
		entity_setMaxSpeed(me, 543)
	end
end

function exitState(me)
end

function hitSurface(me)
end

function damage(me, attacker, bone, damageType, dmg)
	entity_setMaxSpeed(me, 654)
	return true
end

function songNote(me, note)
end
