-- ================================================================================================
-- EEL
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")

-- ================================================================================================
-- FUNCTIONS
-- ================================================================================================

dir = 0
switchDirDelay = 0
wiggleTime = 0
wiggleDir = 1
interestTimer = 0
colorRevertTimer = 0

collisionSegs = 25
avoidLerp = 0
avoidDir = 1
interest = false
STATE_AROUND = 1001
dir = 0
idleDelay = 3

n = 0

bone_body = 0

-- initializes the entity
function init(me)
-- oldhealth : 40
	setupBasicEntity(
	me,
	"",						-- texture
	50,								-- health
	1,								-- manaballamount
	1,								-- exp
	1,								-- money
	32,								-- collideRadius (only used if hit entities is on)
	STATE_IDLE,						-- initState
	90,								-- sprite width
	90,								-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	0,								-- 0/1 hit other entities off/on (uses collideRadius)
	-1,							-- updateCull -1: disabled, default: 4000
	0
	)
	
	entity_setDropChance(me, 50)
	
	lungeDelay = 1.0				-- prevent the nautilus from attacking right away

	entity_initHair(me, 64, 8, 64, "ekkrit/tail")
	--[[
	entity_initSegments(
	25,								-- num segments
	2,								-- minDist
	12,								-- maxDist
	"wurm-body",						-- body tex
	"wurm-tail",						-- tail tex
	128,								-- width
	128,								-- height
	0.01,							-- taper
	0								-- reverse segment direction
	)
	]]--
	
	if chance(50) then
		dir = 0
	else
		dir = 1
	end
	
	if chance(50) then
		interest = true
	end
	switchDirDelay = math.random(800)/100.0
	naija = getNaija()
	
	entity_addVel(me, math.random(1000)-500, math.random(1000)-500)
	entity_setDeathParticleEffect(me, "Explode")
	
	entity_initSkeletal(me, "Ekkrit")
	entity_generateCollisionMask(me)
	entity_animate(me, "idle", LOOP_INF)
	entity_setDeathScene(me, true)
	entity_setCullRadius(me, 1024)
	
	entity_setDamageTarget(me, DT_AVATAR_LIZAP, false)
	entity_setDamageTarget(me, DT_AVATAR_PET, false)
	
	bone_body = entity_getBoneByName(me, "Body")
	
	loadSound("EkkritCall")
	loadSound("EkkritHit")
	loadSound("EkkritIdle")
end

function postInit(me)
	n = getNaija()
end

lastRot = 0
timer = 0
-- the entity's main update function
function update(me, dt)
	idleDelay = idleDelay - dt
	if idleDelay < 0 then
		entity_sound(me, "EkkritIdle", (math.random(300)+800)/1000.0)
		idleDelay = math.random(3) + 3
	end
	if entity_isState(me, STATE_AROUND) then
		dt = dt * 1.5
	end
	if colorRevertTimer > 0 then
		colorRevertTimer = colorRevertTimer - dt
		if colorRevertTimer < 0 then
			entity_setColor(me, 1, 1, 1, 3)
		end
	end
	

	--entity_handleShotCollisionsHair(me, collisionSegs)
	-- in idle state only
	if entity_getState(me)==STATE_IDLE then		
		entity_doCollisionAvoidance(me, dt, 16, 0.05)
		entity_doCollisionAvoidance(me, dt, 4, 0.5)
	end

	if not entity_hasTarget(me) then
		entity_findTarget(me, 500)
	else
		-- has target
		if entity_isState(me, STATE_IDLE) then
			--debugLog(string.format("timer: %f", timer))
			t = 6
			if entity_getRotation(me) > lastRot then
				timer = timer + dt 
				if timer > t then
					dir = 1
					entity_setState(me, STATE_AROUND)
					timer = 0	
				end
			elseif entity_getRotation(me) < lastRot then
				timer = timer - dt
				if timer < -t then
					dir = 0
					entity_setState(me, STATE_AROUND)
					timer = 0
				end
			end
			lastRot = entity_getRotation(me)
			if entity_isNearObstruction(entity_getTarget(me), 4) then
				entity_moveTowardsTarget(me, dt, -100)
			else
				entity_moveTowardsTarget(me, dt, 500)
			end
		elseif entity_isState(me, STATE_AROUND) then
			entity_moveAroundTarget(me, dt, 5000, dir)
			entity_doCollisionAvoidance(me, dt, 16, 0.5)
			entity_doCollisionAvoidance(me, dt, 4, 1.0)
		end
	end
	--entity_flipToVel(me)
	entity_rotateToVel(me, 0.3)
	entity_updateMovement(me, dt)	
	entity_setHairHeadPosition(me, entity_x(me), entity_y(me))
	entity_updateHair(me, dt)
	entity_handleShotCollisionsSkeletal(me)
	
	--[[
	if entity_collideHairVsCircle(me, naija, collisionSegs) then
		entity_touchAvatarDamage(me, 0, 0, 500)
	end
	]]--

	bone = entity_collideSkeletalVsCircle(me, naija)
	if bone ~= 0 then
		if avatar_isBursting() and bone == bone_body and entity_setBoneLock(n, me, bone) then
		else
			bx, by = bone_getWorldPosition(bone)
			x, y = entity_getPosition(n)
			x = x - bx
			y = y - by
			x,y = vector_setLength(x, y, 800)
			entity_addVel(n, x, y)
		end
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_setNaijaReaction(me, "")
		entity_setMaxSpeedLerp(me, 1, 0.5)
		entity_setMaxSpeed(me, 200)
	elseif entity_isState(me, STATE_AROUND) then
		entity_setNaijaReaction(me, "smile")
		entity_sound(me, "EkkritCall", (math.random(100)+950)/1000.0)
		entity_setMaxSpeedLerp(me, 2.5)		
		entity_setStateTime(me, 5)
	elseif entity_isState(me, STATE_DEATHSCENE) then
		entity_setNaijaReaction(me, "shock")
		entity_setStateTime(me, -1)
		entity_offset(me, 0, 10, 0.5, -1, 1)
		shakeCamera(10, 3)
		cam_toEntity(me)
		watch(2)
		cam_toEntity(getNaija())
		entity_setStateTime(me, 0.1)
	end
end

function exitState(me)
	if entity_isState(me, STATE_AROUND) then
		entity_setState(me, STATE_IDLE)
	end
end

function hitSurface(me)
end

function damage(me, attacker, bone, damageType, dmg)
	entity_sound(me, "EkkritHit", (math.random(100)+950)/1000.0)
	entity_setMaxSpeedLerp(me, 5)
	entity_setMaxSpeedLerp(me, 1, 3)
	entity_addVel(me, entity_velx(me)*2, entity_vely(me)*2)
	entity_doSpellAvoidance(me, 1, 32, 1)
	timer = 0
	return true
end

function songNote(me, note)
end
