-- ================================================================================================
-- Energy Boss CLIMB
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")

node = 0

speed = 550

function init(me)	
	setupBasicEntity(
	me,
	"",								-- texture
	30,								-- health
	1,								-- manaballamount
	1,								-- exp
	1,								-- money
	0,								-- collideRadius (only used if hit entities is on)
	STATE_IDLE,						-- initState
	90,								-- sprite width
	90,								-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	0,								-- 0/1 hit other entities off/on (uses collideRadius)
	4000							-- updateCull -1: disabled, default: 4000
	)
	entity_initSkeletal(me, "EnergyBoss")
	entity_setState(me, STATE_IDLE)
	entity_setCull(me, false)	
	entity_setName(me, "EnergyBossClimb")
	
	--entity_flipHorizontal(me)	
	entity_generateCollisionMask(me)	
	node = getNode("NARROW")	
end

function update(me, dt)
	entity_handleShotCollisionsSkeletal(me)
	
	bone = entity_collideSkeletalVsCircle(me, getNaija())
	if bone ~= 0 then
		entity_damage(getNaija(), me, 1000)
		entity_push(getNaija(), 0, -1200, 1)
	end

	if entity_y(me)-256 > node_y(node) then
		entity_setPosition(me, entity_x(me), entity_y(me) - speed * dt)
	end
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", LOOP_INF)
	end
end

function exitState(me)
end

function activate(me)
end

function hitSurface(me)
end

