dofile("scripts/entities/entityinclude.lua")

n = 0

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_ENEMY)
	entity_setAllDamageTargets(me, false)
	
	entity_generateCollisionMask(me)	
	
	entity_setTexture(me, "Test/Kurtz")
	
	entity_setState(me, STATE_IDLE)
	
	entity_setCollideRadius(me, 128)
	
	entity_rotate(me, 360, 10, -1)
	
	entity_addVel(me, randVector(1000))
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
	entity_updateMovement(me, dt)

	if entity_touchAvatarDamage(me, entity_getCollideRadius(me), 0) then
		if avatar_isBursting() and entity_setBoneLock(n, me) then
			-- yay!
		else
			x, y = entity_getVectorToEntity(me, n, 1000)
			entity_addVel(n, x, y)
		end
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

