dofile("scripts/entities/entityinclude.lua")

n = 0

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_ENEMY)
	entity_setTexture(me, "final-mutant-0001")	

	entity_setCollideRadius(me, 20)
	
	entity_setState(me, STATE_IDLE)
	
	entity_setHealth(me, 6)
	
	entity_setDropChance(me, 20, 1)
	entity_scale(me, 0.75, 0.75)
	
	entity_setDeathParticleEffect(me, "TinyRedExplode")
	entity_setUpdateCull(me, 3000)
	
	entity_setMaxSpeedLerp(me, 0.5)
	
	esetv(me, EV_TYPEID, EVT_GATEWAYMUTANT)
end

function postInit(me)
	n = getNaija()
	--entity_setTarget(me, n)
end

function update(me, dt)
	
	if not entity_hasTarget(me) then
		entity_findTarget(me, 800)
		if entity_hasTarget(me) then
			entity_moveTowardsTarget(me, 1, 500)
		end
	else		
		entity_moveTowardsTarget(me, dt, 800)
		entity_findTarget(me, 2000)
	end
	entity_doEntityAvoidance(me, dt, 32, 1)
	entity_doCollisionAvoidance(me, dt, 4, 0.2)
	entity_updateMovement(me, dt)
	entity_rotateToVel(me, 0, 90)
	
	
	
	entity_handleShotCollisions(me)
	if entity_touchAvatarDamage(me, entity_getCollideRadius(me), 0.75, 400) then
		entity_moveTowardsTarget(me, 1, -500)
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
		entity_setMaxSpeed(me, 500)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	-- eh... not going to happen
	--[[
	if damageType == DT_AVATAR_DUALFORMLI then
		entity_changeHealth(me, -1000)
		return true
	end
	]]--
	return true
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

function dieNormal(me)
	--spawnIngredient("RubberyMeat", entity_x(me), entity_y(me))
end

