-- energy door
dofile("scripts/entities/doorcommon.lua")

--commonInit(me, "Final-Tongue", "TentacleDoor", 4.5, 0)

ix = 0
iy = 0
dist = 4048

function init(me)
	setupEntity(me, "Final-Tongue", -2)
	entity_scale(me, 4.5, 4.5)
	entity_setFillGrid(me, true)
	
	entity_setEntityLayer(me, -3)
	entity_setSegs(me, 2, 32, 0.15, 0.15, -0.018, 0, 6, 1)
	loadSound("tentacledoor")
end

function postInit(me)
	ix = entity_x(me)
	iy = entity_y(me)
	
	if entity_isFlag(me, 1) then
		entity_setState(me, STATE_OPENED)
	end
end

function update(me, dt)
	if entity_isState(me, STATE_OPEN) then
		--reconstructEntityGrid()
		if not entity_isInterpolating(me) then
			shakeCamera(4, 1)
			entity_setState(me, STATE_OPENED)
		end
	end
end

function enterState(me, state)
	if entity_isState(me, STATE_OPEN) then
		playSfx("tentacledoor")
		entity_alpha(me, 0, 6)
		entity_setPosition(me, ix, iy + dist, 6, 0, 0, 1)
	elseif entity_isState(me, STATE_OPENED) then
		entity_setPosition(me, ix, iy + dist)
		entity_alpha(me, 0)
		reconstructEntityGrid()
		entity_setFlag(me, 1)
	end
end

function exitState(me, state)
	if entity_isState(me, STATE_OPEN) then
		entity_setState(me, STATE_OPENED)
	end
end



