-- ===============================================================================================
-- SPORE CHILD
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")

growth = 0
growTime = 5
growEmitter = 0
seekEnemy = 0
seekEnemyDelay = 1.5

minSpeed = 450
maxSpeed = 700

backAway = 0
backAwayTime = 0.75

myType = 1

function init(me)
	setupBasicEntity(
	me,
	"SporeChildSeed",				-- texture
	1,								-- health
	2,								-- manaballamount
	2,								-- exp
	10,								-- money
	16,								-- collideRadius (for hitting entities + spells)
	STATE_IDLE,						-- initState
	64,								-- sprite width	
	64,								-- sprite height
	1,								-- particle "explosion" type, 0 = none
	0,								-- 0/1 hit other entities off/on (uses collideRadius)
	-1,								-- updateCull -1: disabled, default: 4000
	1
	)
	
	entity_initEmitter(me, growEmitter, "SporeSeedGrow")
	
	entity_setCollideRadius(me, 64)
	entity_setEntityType(me, ET_ENEMY)
	
	entity_setDamageTarget(me, DT_AVATAR_ENERGYBLAST, false)
	entity_setDamageTarget(me, DT_AVATAR_SHOCK, false)
	entity_setDamageTarget(me, DT_AVATAR_BITE, true)
	--entity_setDamageTarget(me, DT_AVATAR_VOMIT, false)
	--entity_setDamageTarget(me, DT_AVATAR_SPORECHILD, false)
	
	entity_setState(me, STATE_SEED)
	
	entity_setWeight(me, 100)
	
	seekEnemy = seekEnemyDelay
end

function update(me, dt)
	entity_handleShotCollisions(me)
	entity_updateMovement(me, dt)
	if entity_isState(me, STATE_SEED) then
	end
end

function hitSurface(me)
	entity_delete(me)
	createEntity("UberVine", "", entity_x(me), entity_y(me))
end

function enterState(me)
	if entity_isState(me, STATE_SEED) then
		
	end
end

function damage(me, attacker, bone, damageType, dmg)
	if damageType == DT_AVATAR_ENERGYBLAST then
		return false
	end
	if damageType == DT_AVATAR_BITE then
		debugLog("bite!!")
		entity_delete(me)
		return true
	end
	return true
end

function exitState(me)
end
