dofile("scripts/entities/entityinclude.lua")

timer 			= 0
growTime 		= 0.2
size			= 32
life			= 4

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_ENEMY)
	
	entity_setTexture(me, "ForestGod/Vine")
	
	entity_setCollideRadius(me, size)
	entity_setState(me, STATE_IDLE)
	
	entity_setCanLeaveWater(me, true)
	
	entity_alpha(me, 0)
	entity_alpha(me, 1, 0.2)
	
	entity_setEntityLayer(me, -1)
	
	entity_setDeathSound(me, "")
	

	--[[
	entity_setDamageTarget(me, DT_AVATAR_PET, false)
	entity_setDamageTarget(me, DT_AVATAR_BITE, false)
	]]--
	entity_setAllDamageTargets(me, false)
	
	entity_scale(me, 1.2, 1.2)
	esetv(me, EV_LOOKAT, 0)
	
	esetv(me, EV_TYPEID, EVT_FORESTGODVINE)
end

function postInit(me)
	n = getNaija()
end

function songNote(me, note)
end

function update(me, dt)
	if life < 0 then return end
	
	if entity_getAlpha(me) > 0.6 then
		if entity_touchAvatarDamage(me, size, 1, 1000) then
			entity_clearVel(n)
			entity_touchAvatarDamage(me, size, 1, 1000)
		end
	end
	
	life = life - dt
	if life < 0 then
		entity_delete(me, 0.5)
		entity_alpha(me, 0, 0.5)
	end
	
	entity_setDamageTarget(me, DT_AVATAR_ENERGYBLAST, true)
	entity_setDamageTarget(me, DT_AVATAR_SHOCK, true)
	entity_setDamageTarget(me, DT_AVATAR_LIZAP, true)
	
	entity_handleShotCollisions(me)
	
	entity_setDamageTarget(me, DT_AVATAR_ENERGYBLAST, false)
	entity_setDamageTarget(me, DT_AVATAR_SHOCK, false)
	entity_setDamageTarget(me, DT_AVATAR_LIZAP, false)
end

function hitSurface(me)
end

function enterState(me)
	if entity_isState(me, STATE_OFF) then
		life = 0
		entity_delete(me, 0.5)
		entity_alpha(me, 0, 0.5)
	end
end

function damage(me, attacker, bone, damageType, dmg)
	if damageType == DT_AVATAR_BITE then
		--entity_setHealth(me, 0)
		--return true
		return false
	end
	return false
end

function exitState(me)
end
