dofile("scripts/entities/entityinclude.lua")
charge = 0
delay = 1

function init(me)
	setupEntity(me, "FormUpgrades/EnergyIdol")
	entity_setDamageTarget(me, DT_AVATAR_ENERGYBLAST, false)
	
	entity_setCollideRadius(me, 50)
	
	entity_setMaxSpeed(me, 450)
	
	entity_setEntityType(me, ET_ENEMY)
	entity_setAllDamageTargets(me, false)
	entity_setDamageTarget(me, DT_AVATAR_SHOCK, true)
	entity_setDamageTarget(me, DT_AVATAR_ENERGYBLAST, true)

	
	if hasFormUpgrade(FORMUPGRADE_ENERGY2) then
		entity_setState(me, STATE_CHARGED)
	end
end

function hitSurface(me)
	entity_setWeight(me, 0)
	entity_clearVel(me)
end

function update(me, dt)
	entity_handleShotCollisions(me)

	entity_updateMovement(me, dt)
	entity_updateCurrents(me)
	
	if not entity_isState(me, STATE_CHARGED) then
		delay = delay - dt
		if delay < 0 then
			delay = 0.5
			charge = charge - 1
			if charge < 0 then
				charge = 0
			end
		end
	end
end

function enterState(me)
	if entity_isState(me, STATE_CHARGED) then
		entity_setAllDamageTargets(me, false)
		entity_setTexture(me, "FormUpgrades/EnergyIdol-Charged")
		--debugLog(msg("GET ENERGY FORM UPGRADE!"))
		learnFormUpgrade(FORMUPGRADE_ENERGY2)
	elseif entity_isState(me, STATE_INHOLDER) then
		entity_setWeight(me, 0)
		entity_clearVel(me)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)	
	if not entity_isState(me, STATE_CHARGED) then
		if damageType == DT_AVATAR_ENERGYBLAST then
			--charge = charge + dmg
		elseif damageType == DT_AVATAR_SHOCK then
			charge = charge + 10
		end
		if charge >= 10 then
			playSfx("EnergyOrbCharge")
			spawnParticleEffect("EnergyOrbCharge", entity_x(me), entity_y(me))
			setControlHint("Naija's Energy Form has been upgraded. Energy Blasts will deal more damage.", 0, 0, 0, 8)
			entity_setState(me, STATE_CHARGED)			
		end
	end
	return false
end

function activate(me)
end
