dofile("scripts/entities/entityinclude.lua")

n = 0
t = 0
b = 0

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_ENEMY)
	entity_initSkeletal(me, "gateway")	
	entity_setAllDamageTargets(me, false)
	
	entity_setEntityLayer(me, -2)

	
	
	for i=0,4 do
		bone_setSegs(entity_getBoneByIdx(me, i), 2, 8, 0.8, 0.8, -0.018, 0, 6, 1)
	end
	
	b = entity_getNearestNode(me, "gatewayblock")
	if b ~= 0 and node_isEntityIn(b, me) then
	else
		b = 0
	end
	
	entity_setHealth(me, 2)
	
	entity_scale(me, 1.5, 1.5)
	
	entity_generateCollisionMask(me)
	
	entity_setState(me, STATE_IDLE)
	
	entity_setDamageTarget(me, DT_AVATAR_DUALFORMNAIJA, true)
	
	entity_setDeathScene(me, true)
	
	entity_setUpdateCull(me, 3000)
	
	entity_setCullRadius(me, 1024)
	
	entity_setDropChance(me, 100, 2)
	
	loadSound("gateway-die")
	
	entity_setDeathSound(me, "")
	
	entity_setDamageTarget(me, DT_AVATAR_PET, false)
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
	--entity_updateMovement(me, dt)
	
	entity_handleShotCollisionsSkeletal(me)
	
	if b ~= 0 then
		if node_isEntityIn(b, n) then
			xd = entity_x(n) - node_x(b)
			yd = 0
			vector_setLength(xd, yd, 1000)
			entity_addVel(n, xd, yd)
			entity_touchAvatarDamage(me, 0, 1, 0, 1)
			avatar_fallOffWall()
		end
	end
		
	bone = entity_collideSkeletalVsCircle(me, n)
	if bone ~= 0 then
		entity_clearVel(n)
		if entity_x(n) > entity_x(me) then
			entity_addVel(n, 500, 0)
		else
			entity_addVel(n, -500, 0)
		end
		entity_touchAvatarDamage(me, 0, 1, 0, 1)
		avatar_fallOffWall()
	end
	
	
	t = t + dt
	if t > 4 then
		toomany = 4
		c = 0
		e = getFirstEntity()
		while e~=0 do
			if entity_isEntityInRange(me, e, 1500) then
				if eisv(e, EV_TYPEID, EVT_GATEWAYMUTANT) then
					c = c + 1
					if c >= toomany then
						break
					end
				end
			end
			e = getNextEntity()
		end
		if c < toomany then
			e = createEntity("final-mutant", "", entity_x(me), entity_y(me))
			spawnParticleEffect("tinyredexplode", entity_x(e), entity_y(e))
			entity_alpha(e, 0)
			entity_alpha(e, 1, 0.5)
		end
		t = 0
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
	elseif entity_isState(me, STATE_DEATHSCENE) then
		entity_setStateTime(me, 99)
		
		playSfx("gateway-die")
		
		spawnParticleEffect("gateway-die", entity_x(me), entity_y(me))
		entity_idle(n)
		entity_flipToEntity(n, me)
		cam_toEntity(me)
		shakeCamera(4, 4)
		entity_offset(me, 5, 0, 0.1, -1)
		entity_setColor(me, 1, 0.2, 0.2, 5)
		for i=0,4 do
			bone_setSegs(entity_getBoneByIdx(me, i), 2, 8, 1, 1, -0.1, 0, 6, 0)
		end
		watch(2)
		cam_toEntity(n)
		entity_setStateTime(me, 0)
		
		spawnParticleEffect("gateway-die", entity_x(me), entity_y(me))
		
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	if damageType == DT_AVATAR_DUALFORMNAIJA then
		return true
	end
	
	playNoEffect()
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

