-- ================================================================================================
-- G R A B B Y   A R M   (beta)
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")

-- ================================================================================================
-- L O C A L   V A R I A B L E S
-- ================================================================================================
 
grabDelay = 0

n = 0
li = 0
grabbedEnt = 0

numGrabHits = 6
grabHits = numGrabHits

bone_front = 0
bone_back = 0





sz = 1.1

-- ================================================================================================
-- S T A T E S
-- ================================================================================================

STATE_TRAP		= 1001
STATE_IN	= 1002
STATE_OUT	= 1003

-- ================================================================================================
-- F U N C T I O N S
-- ================================================================================================

function init(me)
	setupBasicEntity(
	me,
	"GrabbyArm/Front",				-- texture
	12,								-- health
	0,								-- manaballamount
	69,								-- exp
	69,								-- money
	54,								-- collideRadius (only used if hit entities is on)
	STATE_IDLE,						-- initState
	128,							-- sprite width	
	128,							-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	0,								-- 0/1 hit other entities off/on (uses collideRadius)
	2000							-- updateCull -1: disabled, default: 4000
	)
	
	entity_setCullRadius(me, 1024)
	
	entity_initSkeletal(me, "GrabbyArm")
	bone_front = entity_getBoneByName(me, "Front")
	bone_back = entity_getBoneByName(me, "Back")
	
	bone_setSegs(bone_front, 2, 8, 0.3, 0.3, -0.020, 0, 6, 1)
	bone_setSegs(bone_back, 2, 8, 0.34, 0.34, -0.023, 0, 7, 1)
	
	entity_setState(me, STATE_IDLE)
	
	entity_setAllDamageTargets(me, false)
	
	entity_setEntityLayer(me, -2)
	
	entity_scale(me, sz, sz)
	
	entity_setState(me, STATE_IN, -1, 1)
end

function postInit(me)
entity_animate(me, "idle", LOOP_INF)

	n = getNaija()
	li = getLi()
	
	node = entity_getNearestNode(me, "FLIP")
	if node ~= 0 and node_isEntityIn(node, me) then
		entity_fh(me)
	end
	
	
	
	entity_setInternalOffset(me, 0, 300)
end

function update(me, dt)

	-- GRAB NAIJA AND LI WHEN NEAR
	if entity_getState(me) == STATE_IDLE then
		if grabDelay > 0 then grabDelay = grabDelay - dt
		elseif grabDelay <= 0 then
			grabDelay = 0
			
			grabRange = 74
			if entity_isEntityInRange(me, n, grabRange) then
				grabbedEnt = n
				entity_setState(me, STATE_TRAP)
				
			elseif entity_isEntityInRange(me, li, grabRange) then
				grabbedEnt = li
				entity_setState(me, STATE_TRAP)
				
			end
		end
	elseif entity_isState(me, STATE_IN) then
		if grabDelay > 0 then grabDelay = grabDelay - dt
		elseif grabDelay <= 0 then
			grabRange = 128
			if entity_isEntityInRange(me, n, grabRange) then
				entity_setState(me, STATE_OUT)
			end
		end
	elseif entity_getState(me) == STATE_TRAP then
		if grabbedEnt ~= 0 then
			-- HOLD GRABBED ENTITY
			entity_setPosition(grabbedEnt, entity_x(me), entity_y(me), 0.06)
			
			-- RELEASE GRABBED ENTITY WHEN HURT ENOUGH
			if grabHits <= 0 then
				grabHits = 0
				grabbedEnt = 0
				entity_setState(me, STATE_IN)
			end
			
			-- FREE UP WHEN GRABBED ENTITY IS DEAD
			if entity_isDead(grabbedEnt) then
				grabbedEnt = 0
				entity_setState(me, STATE_IN)
			end
		end
		
		-- Move down, pulling held entity towards a hazzard??
	end
	
	-- COLLISIONS
	entity_handleShotCollisions(me)
end

function enterState(me)
	if entity_getState(me) == STATE_IDLE then
		grabHits = 0
		entity_animate(me, "idle", LOOP_INF)
		entity_setDamageTarget(me, DT_AVATAR_LIZAP, false)
		
	elseif entity_getState(me) == STATE_TRAP then
		grabHits = numGrabHits
		entity_setDamageTarget(me, DT_AVATAR_LIZAP, true)
		toggleLiCombat(true)
	elseif entity_isState(me, STATE_IN) then
		entity_setInternalOffset(me, 0, 300, 1, 0, 0)
		bone_setRenderPass(bone_front, 0)
		entity_setAllDamageTargets(me, false)
	elseif entity_isState(me, STATE_OUT) then
		entity_setAllDamageTargets(me, true)
		t = 0.3
		entity_setInternalOffset(me, 0, 0, t, 0, 0)
		entity_setStateTime(me, t)
		bone_setRenderPass(bone_front, 3)
	end
end

function exitState(me)
	if entity_getState(me) == STATE_IDLE then

	elseif entity_getState(me) == STATE_TRAP then
		grabHits = 0
		entity_setDamageTarget(me, DT_AVATAR_LIZAP, false)
		grabDelay = 3.5
		entity_touchAvatarDamage(me, 64, 0, 321)	-- Bump Naija out when released
	elseif entity_isState(me, STATE_OUT) then
		entity_setState(me, STATE_IDLE)
	end
end

function damage(me, attacker, bone, damageType, dmg, x, y)
	-- HURT TO RELEASE HELD ENTITY
	if entity_isState(me, STATE_TRAP) then 
		grabHits = grabHits - dmg
		bone_damageFlash(bone_front)
	end
	
	return false
end

function animationKey(me, key)
end
