-- ================================================================================================
-- G R O U N D   S H O C K E R   A T T A C K
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")

-- ================================================================================================
-- L O C A L   V A R I A B L E S 
-- ================================================================================================

direction = 0
life = 0.87

-- ================================================================================================
-- F U N C T I O N S
-- ================================================================================================

function commonInit(me, dir)
	setupBasicEntity(
	me,
	"GroundShocker/Shell",			-- texture
	7,								-- health
	1,								-- manaballamount
	0,								-- exp
	0,								-- money
	64,								-- collideRadius (for hitting entities + spells)
	STATE_IDLE,						-- initState
	128,							-- sprite width	
	128,							-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	1,								-- 0/1 hit other entities off/on (uses collideRadius)
	2000							-- updateCull -1: disabled, default: 4000
	)
	
	entity_setDeathParticleEffect(me, "Explode")
	
	entity_setAllDamageTargets(me, false)
	
	esetv(me, EV_WALLOUT, 4)
	esetvf(me, EV_CLAMPTRANSF, 0.2)
	entity_clampToSurface(me)
	
	--entity_scale(me, 0.87, 0.87)
	--entity_alpha(me, 0.87)
	
	entity_alpha(me, 0)
	entity_scale(me, 0)
	
	direction = dir
end

function postInit(me)
	entity_setState(me, STATE_IDLE)
	
	-- FLIP HORIZONTALLY
	if direction >= 1 then 
		entity_fh(me)
		entity_switchSurfaceDirection(me)
	end
end

function update(me, dt)
	-- DESTROY AFTER TIME
	life = life - dt
	if life <= 0 then
		entity_alpha(me, 0, 0.23)
		entity_scale(me, 0, 0, 0.23)
		entity_delete(me, 0.23)
		spawnParticleEffect("GroundShockerShellDestroy", entity_x(me), entity_y(me))
	end
	
	spawnParticleEffect("GroundShockerAttack", entity_x(me), entity_y(me))

	-- MOVE ALONG SURFACE
	if eisv(me, EV_CLAMPING, 0) then	
		entity_moveAlongSurface(me, dt, 640)
	end
	entity_rotateToSurfaceNormal(me, 0.1)
	
	entity_touchAvatarDamage(me, 64, 0.69, 420)
end

function enterState(me)
	if entity_getState(me) == STATE_IDLE then
		entity_animate(me, "idle", LOOP_INF)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function hitSurface(me)
end
