dofile("scripts/entities/entityinclude.lua")

myWeight = 432
onSurface = 0

function init(me)
	setupBasicEntity(
	me,
	"GroundShocker/Shell",			-- texture
	3,								-- health
	0,								-- manaballamount
	0,								-- exp
	0,								-- money
	21,								-- collideRadius (for hitting entities + spells)
	STATE_IDLE,						-- initState
	128,							-- sprite width	
	128,							-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	1,								-- 0/1 hit other entities off/on (uses collideRadius)
	2000							-- updateCull -1: disabled, default: 4000
	)

	entity_setAffectedBySpells(me, 1)
	entity_setBounce(me, 0.2)	
	entity_setCanLeaveWater(me, true)
	
	entity_setAllDamageTargets(me, false)
	
	entity_setMaxSpeed(me, 640)
end

function update(me, dt)
	entity_handleShotCollisions(me)
	entity_updateMovement(me, dt)
	
	if entity_checkSplash(me) then
	end
	if not entity_isUnderWater(me) then
		if not entity_isBeingPulled(me) then
			entity_setWeight(me, myWeight*2)
			entity_setMaxSpeedLerp(me, 5, 0.1)
		end
	else
		entity_setMaxSpeedLerp(me, 1, 0.1)
		entity_setWeight(me, myWeight)
	end
	
	if entity_getVelLen(me) > 76 then 
		entity_rotateToVel(me, 0.34)
	end
	
	-- DESTROY IF ON SURFACE TOO LONG
	if onSurface > 3 then
		entity_alpha(me, 0, 0.12)
		entity_scale(me, 0, 0, 0.12)
		entity_delete(me, 0.12)
		spawnParticleEffect("GroundShockerShellDestroy", entity_x(me), entity_y(me))
	end
	
	entity_touchAvatarDamage(me, 32, 0.13, 321)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function hitSurface(me)
	onSurface = onSurface + 1
end
