dofile("scripts/entities/entityinclude.lua")

n = 0
attackDelay = 2

STATE_GETREADY				= 1000
STATE_FIRING				= 1001

body = 0

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_ENEMY)
	entity_initSkeletal(me, "Guardian")	
	
	entity_generateCollisionMask(me)	
	
	entity_setHealth(me, 64)
	entity_setDeathScene(me, true)
	entity_setState(me, STATE_WAIT)
	entity_setCullRadius(me, 2000)
	entity_scale(me, 2, 2)
	entity_setDeathScene(me, true)
	
	body = entity_getBoneByName(me, "Body")
	
	entity_setTargetRange(me, 2024)
	
	entity_setUpdateCull(me, 3000)
	
	loadSound("Guardian-Die")
	loadSound("Guardian-Attack")
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
	
	node = entity_getNearestNode(me, "FLIP")
	if node ~= 0 and node_isEntityIn(node, me) then
		entity_fh(me)
	end
end

function update(me, dt)
	--entity_updateMovement(me, dt)
	
	if entity_isState(me, STATE_WAIT) then
		if entity_isEntityInRange(me, n, 600) then
			entity_setState(me, STATE_GETREADY)
		end
	end
	
	if entity_isState(me, STATE_IDLE) then
		attackDelay = attackDelay - dt
		if attackDelay <= 0 then
			if not entity_isEntityInRange(me, n, 1024) or chance(10) then
				entity_setState(me, STATE_FIRING)
			else
				entity_setState(me, STATE_ATTACK)
			end
		end
		
	end
	
	if not entity_isState(me, STATE_WAIT) then
		overrideZoom(0.6, 1)
	end
	
	entity_handleShotCollisionsSkeletal(me)
	bone = entity_collideSkeletalVsCircle(me, n)
	if bone ~= 0 then
		if entity_isfh(me) then
			entity_addVel(n, 2000, 0)
		else
			entity_addVel(n, -2000, 0)
		end
		entity_damage(n, me, 1)
	end
	
	if entity_isfh(me) then
		if entity_x(n) > entity_x(me) then
			entity_addVel(n, 1000, 0)
		end
	else
		if entity_x(n) > entity_x(me) then
			entity_addVel(n, -1000, 0)
		end
	end
	entity_clearTargetPoints(me)
	entity_addTargetPoint(me, bone_getWorldPosition(body))
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "ready", -1)
	elseif entity_isState(me, STATE_WAIT) then
		entity_animate(me, "wait", -1)
	elseif entity_isState(me, STATE_GETREADY) then
		entity_setStateTime(me, entity_animate(me, "getReady"))
	elseif entity_isState(me, STATE_ATTACK) then
		playSfx("Guardian-Attack")
		if entity_y(n) < entity_y(me) then
			entity_setStateTime(me, entity_animate(me, "attack"))
		else
			entity_setStateTime(me, entity_animate(me, "attack2"))
		end
	elseif entity_isState(me, STATE_DEATHSCENE) then
		playSfx("Guardian-Die")
		shakeCamera(4, 4)
		overrideZoom(0.5, 0.5)
		entity_setStateTime(me, 99)
		cam_toEntity(me)
		entity_setInvincible(n, true)
		watch(entity_animate(me, "die"))
		entity_color(me, 0, 0, 0, 1)
		watch(1)
		entity_setStateTime(me, 0.01)
		entity_setInvincible(n, false)
		cam_toEntity(n)
	elseif entity_isState(me, STATE_FIRING) then
		entity_setStateTime(me, entity_animate(me, "firing"))
	end
end

function exitState(me)
	if entity_isState(me, STATE_ATTACK) then
		attackDelay = 3
		entity_setState(me, STATE_IDLE)
	elseif entity_isState(me, STATE_GETREADY) then
		entity_setState(me, STATE_IDLE)
	elseif entity_isState(me, STATE_DEATHSCENE) then
		overrideZoom(0, 0.5)
	elseif entity_isState(me, STATE_FIRING) then
		entity_setState(me, STATE_IDLE)
	end
end

function damage(me, attacker, bone, damageType, dmg)
	if entity_isState(me, STATE_WAIT) then
		entity_setState(me, STATE_GETREADY)
		return false
	end
	if bone == body then
		return true
	end

	return false
end

function animationKey(me, key)
	if entity_isState(me, STATE_FIRING) then
		if key == 2 or key == 4 or key == 6 then
			s = createShot("Guardian", me, n, entity_getPosition(me))
			if key == 2 then
				shot_setAimVector(s, -400, -100)
			elseif key == 4 then
				shot_setAimVector(s, -400, 0)
			elseif key == 6 then
				shot_setAimVector(s, -400, 100)
			end
		end
	end
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

