-- ================================================================================================
-- H A R D B E E T L E
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")


-- ================================================================================================
-- L O C A L  V A R I A B L E S 
-- ================================================================================================

fireDelay = 2
moveTimer = 0
sz = 1.0

-- ================================================================================================
-- FUNCTIONS
-- ================================================================================================

function init(me)
	setupBasicEntity(me, 
	"hardbeetle",						-- texture
	499,							-- health
	2,							-- manaballamount
	2,							-- exp
	1,							-- money
	20,							-- collideRadius (for hitting entities + spells)
	STATE_IDLE,						-- initState
	128,							-- sprite width	
	128,							-- sprite height
	1,							-- particle "explosion" type, maps to particleEffects.txt -1 = none
	1,							-- 0/1 hit other entities off/on (uses collideRadius)
	4000							-- updateCull -1: disabled, default: 4000
	)
	
	--entity_offset(0, 128)
		
	-- entity_initPart(partName, partTexture, partPosition, partFlipH, partFlipV,
	-- partOffsetInterpolateTo, partOffsetInterpolateTime
	
	esetv(me, EV_WALLOUT, 40)

	--entity_scale(me, 0.5, 0.5)
	
	entity_setDeathParticleEffect(me, "Explode")
	
	entity_clampToSurface(me)
end

function update(me, dt)

	if entity_touchAvatarDamage(me, entity_getCollideRadius(me), 1, 1000) then
		-- do something maybe
	end
	entity_handleShotCollisions(me)
	-- dt, pixelsPerSecond, climbHeight, outfromwall
	entity_moveAlongSurface(me, dt, 100, 6, 40) --64 --54
	entity_rotateToSurfaceNormal(me, 0.1)	
	-- entity_rotateToSurfaceNormal(0)
	moveTimer = moveTimer + dt
	if moveTimer > 60 then
		entity_switchSurfaceDirection(me)
		moveTimer = 0
	end
	if not(entity_hasTarget(me)) then
		entity_findTarget(me, 1200)
	else
		if fireDelay > 0 then
			fireDelay = fireDelay - dt
			if fireDelay < 0 then
				-- dmg, mxspd, homing, numsegs, out
				--entity_fireAtTarget(me, "BlasterFire", 1, 400, 200, 3, 64)
				fireDelay = 5
			end
		end
	end
end

function enterState(me)
	if entity_getState(me)==STATE_IDLE then
	end
end

function exitState(me)
end

function hitSurface()
end

function damage(me, attacker, bone, damageType, dmg)
	return true
end

function dieNormal(me)
	if chance(100) then
		spawnIngredient("DivineSoup", entity_getPosition(me))
	end
end
