-- ================================================================================================
-- I C E   C R A B
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")

-- ================================================================================================
-- L O C A L   V A R I A B L E S 
-- ================================================================================================

moveTimer = 0

-- ================================================================================================
-- F U N C T I O N S
-- ================================================================================================

function init(me)
	setupBasicEntity(me, 
	"IceCrab/Body",					-- texture
	18,								-- health
	1,								-- manaballamount
	0,								-- exp
	0,								-- money
	34,								-- collideRadius (for hitting entities + spells)
	STATE_IDLE,						-- initState
	128,							-- sprite width	
	128,							-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	1,								-- 0/1 hit other entities off/on (uses collideRadius)
	3210							-- updateCull -1: disabled, default: 4000
	)
	
	entity_setDeathParticleEffect(me, "Explode")
	
	entity_initSkeletal(me, "IceCrab")
	entity_scale(me, 1.1, 1.1)
	
	esetv(me, EV_WALLOUT, 23)
	entity_clampToSurface(me)
end

function postInit(me)
	entity_setState(me, STATE_IDLE)
	
	-- FLIP WITH A FLIP NODE
	node = entity_getNearestNode(me, "FLIP")
	if node ~=0 then
		if node_isEntityIn(node, me) then 
			entity_fh(me)
		entity_switchSurfaceDirection(me)
		end
	end
end

function update(me, dt)
	-- FLIP AFTER A WHILE
	moveTimer = moveTimer + dt
	if moveTimer > 42 then
		entity_switchSurfaceDirection(me)
		entity_fh(me)
		moveTimer = 0
	end

	-- MOVEMENT
	entity_moveAlongSurface(me, dt, 76)
	entity_rotateToSurfaceNormal(me, 0.54)	
	-- COLLISIONS
	entity_touchAvatarDamage(me, 56, 0.76, 321)
	entity_handleShotCollisions(me)
end

function enterState(me)
	if entity_getState(me) == STATE_IDLE then
		entity_animate(me, "idle", LOOP_INF)
	end
end

function damage(me, attacker, bone, damageType, dmg)
	return true
end

function dieNormal(me)
	if chance(50) then
		spawnIngredient("IceChunk", entity_x(me), entity_y(me))
	end
end
