dofile("scripts/entities/entityinclude.lua")

n = 0
glow = 0

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_ENEMY)
	entity_initSkeletal(me, "Kappa")	
	entity_setAllDamageTargets(me, false)
	
	glow = entity_getBoneByName(me, "Glow")
	bone_alpha(glow, 0)
	bone_scale(glow, 2, 2)
	entity_setState(me, STATE_IDLE)
	
	entity_setEntityLayer(me, -3)
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		bone_alpha(glow, 0)
		entity_animate(me, "idle", -1)
	elseif entity_isState(me, STATE_CHARGE1) then
		playSfx("MenuNote0")
		bone_alpha(glow, 1)
		bone_color(glow, 1, 0.5, 0.5)
		bone_alpha(glow, 0, 1)
	elseif entity_isState(me, STATE_CHARGE2) then
		playSfx("MenuNote0")
		bone_alpha(glow, 1)
		bone_color(glow, 1, 1, 0.5)
		
		bone_alpha(glow, 0, 1)
	elseif entity_isState(me, STATE_CHARGE3) then
		playSfx("MenuNote7")
		bone_alpha(glow, 1)
		bone_color(glow, 0.5, 1, 0.5)		
		bone_alpha(glow, 0, 1)
		entity_setStateTime(me, 1)
	end
end

function exitState(me)
	if entity_isState(me, STATE_CHARGE3) then
		entity_setState(me, STATE_IDLE)
	end
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

