-- KRILL EGG

dofile("scripts/entities/entityinclude.lua")

growTimer = 0
scaling = false

function init(me)
	setupBasicEntity(
	me,
	"Krill/KrillEggs",					-- texture
	3,								-- health
	2,								-- manaballamount
	2,								-- exp
	10,								-- money
	32,								-- collideRadius (for hitting entities + spells)
	STATE_IDLE,						-- initState
	64,								-- sprite width	
	64,								-- sprite height
	1,								-- particle "explosion" type, 0 = none
	0,								-- 0/1 hit other entities off/on (uses collideRadius)
	2000,							-- updateCull -1: disabled, default: 4000
	-1
	)
	entity_setAllDamageTargets(me, false)
	entity_setDamageTarget(me, DT_AVATAR_BITE, true)
	growTimer = 6 + math.random(3)	
end

function update(me, dt)
	if not scaling and not entity_isNearObstruction(me, 1) then
		entity_addVel(me, 0, 98*dt)
		entity_updateCurrents(me, dt)
		entity_updateMovement(me, dt)
	else
		entity_rotateToSurfaceNormal(me)
		if entity_isState(me, STATE_IDLE) then
			growTimer = growTimer - dt
			if growTimer < 2 and not scaling then
				scaling = true
				--entity_setInternalOffset(me, 0, 0.5, 0.1, -1)
				entity_scale(me, 1.2, 1, 0.2, -1, 1)
				entity_alpha(me, 0.01, 1)
				
				ent = createEntity("Krill", "", entity_getPosition(me))
				entity_rotate(ent, entity_getRotation(me))
				entity_setState(ent, STATE_GROW)			
			end
			if growTimer < 0 then
				entity_delete(me)
				growTimer = 999
			end
		end
	end
	if not scaling then
		entity_handleShotCollisions(me)
	end
end

function enterState(me)
end

function hitSurface(me)
end

function damage(me, attacker, bone, damageType, dmg)
	if damageType == DT_AVATAR_BITE then
		entity_changeHealth(me, -100)
	end
	return true
end

function exitState(me)
end
