dofile("scripts/entities/entityinclude.lua")

n = 0

function init(me)
	setupEntity(me)
	entity_initSkeletal(me, "Krotite")	
	
	entity_scale(me, 0.7, 0.7)
	
	
	noteBone = entity_getBoneByName(me, "Note")
	glow = entity_getBoneByName(me, "Glow")
	
	bone_setVisible(noteBone, false)
	bone_setVisible(glow, false)
	
	entity_setState(me, STATE_IDLE)
	
	entity_addVel(me, 200, 200)
end

function postInit(me)
	debugLog("KROTITE POST INIT!")
	n = getNaija()

	entity_setTarget(me, n)
	
	node = entity_getNearestNode(me, "WORSHIP2")
	if node ~= 0 and node_isEntityIn(node, me) then
		entity_animate(me, "worship2", -1)
	else
	
	end
	
	entity_animate(me, "swim", -1)
	entity_updateSkeletal(me, math.random(4))
end

done = false

function update(me, dt)
	if entity_isAnimating(me) and not done then
		entity_updateSkeletal(me, math.random(4))
		done = true
	end
	if entity_isState(me, STATE_ON) then
		entity_addVel(me, 150, 100, dt)
		entity_doCollisionAvoidance(me, dt, 10, 0.5)
		entity_updateMovement(me, dt)
		entity_flipToVel(me)
		entity_rotateToVel(me)
	end
	
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

