-- LIGHT CRYSTAL

dofile("scripts/entities/entityinclude.lua")
charge = 0
delay = 1
glow = 0

function init(me)
	setupEntity(me)
	
	entity_setDamageTarget(me, DT_AVATAR_ENERGYBLAST, false)
	entity_setProperty(me, EP_MOVABLE, true)
	entity_setCollideRadius(me, 32)
	entity_setWeight(me, 300)
	
	entity_setMaxSpeed(me, 450)
	
	entity_setEntityType(me, ET_NEUTRAL)
	
	entity_initSkeletal(me, "LightCrystal")
	entity_animate(me, "idle", -1)
	bone_glow = entity_getBoneByName(me, "Glow")
	bone_alpha(bone_glow, 0)
	glow = createQuad("Naija/LightFormGlow", 13)
	quad_scale(glow, 6, 6)
	quad_alpha(glow, 0)
end

function update(me, dt)
	entity_updateMovement(me, dt)
	entity_updateCurrents(me)
	quad_setPosition(glow, entity_getPosition(me))
end

function enterState(me)
	if entity_isState(me, STATE_CHARGED) then
		quad_alpha(glow, 1)
		bone_alpha(bone_glow, 1)
	elseif entity_isState(me, STATE_CHARGE) then
		quad_alpha(glow, 1, 1.5)
		bone_alpha(bone_glow, 1, 1.5)
		playSfx("SunForm")
	elseif entity_isState(me, STATE_DEAD) then
		quad_delete(glow)
	end
end

function exitState(me)
end

function hitSurface(me)
	--entity_sound(me, "rock-hit")
end

function damage(me, attacker, bone, damageType, dmg)	
	return false
end

function activate(me)
end
