dofile("scripts/entities/entityinclude.lua")

n = 0
bone_head = 0

normal = 0
angry = 1
happy = 2
hurt = 3
laugh = 4
surprise = 5

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_NEUTRAL)
	
	entity_setAllDamageTargets(me, false)
	
	entity_scale(me, 0.5, 0.5)
	
	entity_generateCollisionMask(me)	
	
	entity_setState(me, STATE_IDLE)
	
	esetv(me, EV_LOOKAT, 0)
	
	doSkel(me, "Li", "")
end

function doSkel(me, skel, skin)
	entity_initSkeletal(me, skel, skin)	
	bone_head = entity_getBoneByName(me, "Head")
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

function msg(me, m)
	if m == "smile" then
		bone_showFrame(bone_head, happy)
	elseif m == "normal" then
		bone_showFrame(bone_head, 0)
	elseif m == "surprise" then
		bone_showFrame(bone_head, surprise)
	elseif m == "end" then
		doSkel(me, "Li", "li-end")
	end
end

