dofile("scripts/entities/entityinclude.lua")

n = 0

STATE_CHASE			= 1000
STATE_RUN			= 1001

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_NEUTRAL)
	entity_initSkeletal(me, "merchild")
	
	entity_setState(me, STATE_IDLE)
	
	entity_scale(me, 0.55, 0.55)
end

function postInit(me)
	n = getNaija()
	

	
	nd = entity_getNearestNode(me, "skin1")
	if nd~=0 and node_isEntityIn(nd, me) then
		entity_initSkeletal(me, "merchild", "merchild-skin1")
	end
	
	nd = entity_getNearestNode(me, "flip")
	if nd~=0 and node_isEntityIn(nd, me) then
		entity_fh(me)
	end
	
	if not entity_isState(me, STATE_RUN) then
		entity_animate(me, "idle", -1)
	end
	
	nd = entity_getNearestNode(me, "chase")
	if nd~=0 and node_isEntityIn(nd, me) then
		ent = entity_getNearestEntity(me, "merchild")
		entity_setTarget(me, ent)
		entity_msg(ent, "run", me)
		entity_setState(me, STATE_CHASE)
		entity_animate(me, "swim", -1)
		entity_setMaxSpeed(me, 300)
		--entity_initSkeletal(me, "merchild", "merchild-skin1")
	end
	
	
end

function update(me, dt)
	entity_updateMovement(me, dt)
	
	if entity_isState(me, STATE_CHASE) then
		entity_moveTowardsTarget(me, dt, 500)
		entity_doCollisionAvoidance(me, dt, 8, 0.5)
		entity_rotateToVel(me)
		entity_flipToVel(me)
	elseif entity_isState(me, STATE_RUN) then
		entity_moveTowardsTarget(me, dt, -800)
		entity_doCollisionAvoidance(me, dt, 8, 0.5)
		entity_rotateToVel(me)
		entity_flipToVel(me)
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		--entity_animate(me, "idle", -1)
	elseif entity_isState(me, STATE_CHASE) then
		
	end
end

function msg(me, str, v)
	if str == "run" then
		entity_setTarget(me, v)
		entity_setState(me, STATE_RUN, -1, 1)
		entity_setMaxSpeed(me, 350)
		
		entity_animate(me, "swim", -1)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

