-- ================================================================================================
-- AGGRO HOPPER
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")
-- specific
STATE_JUMP				= 1000
STATE_TRANSITION		= 1001
STATE_JUMPPREP			= 1002
STATE_WALK				= 1003

-- ================================================================================================
-- L O C A L  V A R I A B L E S 
-- ================================================================================================

jumpDelay = 0
moveTimer = 0
rotateOffset = 0
angry = false
enraged = false
moving = 1
n = 0

fireDelay = 0

lx = 0
ly = 0

angle = 0.0

bubbleRelease = 0

-- ================================================================================================
-- FUNCTIONS
-- ================================================================================================

--[[
function land(me)
	entity_clampToSurface(me)
	entity_moveAlongSurface(me, dt, 1, 6, 24)
	entity_rotateToSurfaceNormal(me, 0.1)
end
]]--

function init(me)

	setupBasicEntity(
	me,
	"",								-- texture
	12,								-- health
	2,								-- manaballamount
	2,								-- exp
	10,								-- money
	40,								-- collideRadius
	STATE_IDLE,						-- initState
	128,							-- sprite width	
	128,							-- sprite height
	1,								-- particle "explosion" type, 0 = none
	0,								-- 0/1 hit other entities off/on (uses collideRadius)
	4000							-- updateCull -1: disabled, default: 4000
	)
	entity_initSkeletal(me, "Mermog")
	
	entity_setDeathParticleEffect(me, "TinyGreenExplode")
	
	--land(me)
	entity_setWeight(me, 1000)
	entity_setState(me, STATE_IDLE)
	
	entity_setBounceType(me, BOUNCE_REAL)
	entity_setBounce(me, 0.9)
	--entity_setClampOnSwitchDir(me, false)
	esetv(me, EV_SWITCHCLAMP, 0)
	esetv(me, EV_WALLOUT, 64)--18)
	
	entity_clampToSurface(me)
	
	entity_setCullRadius(me, 512)
	
	entity_setDeathSound(me, "mermog-die")

	loadSound("mermog-die")
	loadSound("mermog-jump")
end

function postInit(me)
	n = getNaija()
end

function update(me, dt)
	lx,ly = entity_getPosition(me)
	
	if enraged then
		dt = dt * 1.25
	end	
	--[[
	if entity_hasTarget(me) then
		if entity_isTargetInRange(me, 64) then
			entity_hurtTarget(me, 1)
			entity_pushTarget(me, 500)
		end
	end
	]]--
	if entity_isState(me, STATE_IDLE) or entity_isState(me, STATE_TRANSITION) then
		entity_moveAlongSurface(me, dt, 0.5, 6)
		--entity_switchSurfaceDirection(me)
	end
	if entity_getState(me)==STATE_IDLE then
		if not(entity_hasTarget(me)) then
			entity_findTarget(me, 1200)
		else
			if entity_isTargetInRange(me, 900) then
				jumpDelay = jumpDelay - dt
				if jumpDelay < 0 then
					angry = true
					jumpDelay = 0.2
					entity_setState(me, STATE_JUMPPREP)
				end
			end
		end		
	elseif entity_isState(me, STATE_WALK) then
		if entity_isfh(me) then
			entity_switchSurfaceDirection(me, 0)
		else
			entity_switchSurfaceDirection(me, 1)
		end
		entity_moveAlongSurface(me, dt, 1000*moving, 6)
		entity_rotateToSurfaceNormal(me, 0.1)
	elseif entity_getState(me)==STATE_JUMPPREP then
		if not entity_isAnimating(me) then
			entity_setState(me, STATE_JUMP)
		end
	elseif entity_getState(me)==STATE_JUMP then
		--entity_flipToVel(me)
		entity_updateCurrents(me, dt)
		entity_updateMovement(me, dt)
		
		bubbleRelease = bubbleRelease - dt
		if bubbleRelease < 0 then
			bubbleRelease = 0.4
			spawnParticleEffect("bubble-release-short", entity_x(me), entity_y(me))
		end
		
		--[[
		fireDelay = fireDelay - dt
		if fireDelay < 0 then
			fireDelay = 0.4
			s = createShot("mermog-shot", me, n, entity_x(me), entity_y(me))
		end
		]]--
	elseif not(entity_getState(me)==STATE_TRANSITION or entity_isState(me, STATE_WALK)) then
		entity_updateMovement(me, dt)
	end
	

	--[[
	if isObstructed(entity_x(me), entity_y(me)) then
		entity_setPosition(me, lx, ly)
		entity_clampToSurface(me)
	end
	]]--
	
	entity_handleShotCollisions(me)
	entity_touchAvatarDamage(me, 64, 1, 500)
	
	if isObstructed(entity_x(me), entity_y(me)) then
		entity_adjustPositionBySurfaceNormal(me, 1)
	end
end

function damage(me, attacker, bone, damageType, dmg)
	if entity_isState(me, STATE_IDLE) then
		entity_setState(me, STATE_JUMPPREP)
	end
	return true
end

bounces = 0
function hitSurface(me)
	if entity_getState(me)==STATE_JUMP then
		t = egetvf(me, EV_CLAMPTRANSF)
		if entity_checkSurface(me, 6, STATE_TRANSITION, t) then
			entity_rotateToSurfaceNormal(me, 0)
			entity_scale(me, 1, 0.5)
			entity_scale(me, 1, 1, t)
			--[[
			entity_setInternalOffset(me, 0, 64)
			entity_setInternalOffset(me, 0, 0, t)
			]]--
		else
			nx,ny = getWallNormal(entity_getPosition(me))
			nx,ny = vector_setLength(nx, ny, 400)
			entity_addVel(me, nx, ny)
		end
		--[[
		if entity_isNearObstruction(me, 4, OBSCHECK_4DIR) then
			entity_clampToSurface(me)
			entity_setState(me, STATE_TRANSITION, 0.001)
		end
		]]--
	end
	--[[
	if entity_getState(me)==STATE_JUMP then
		nx, ny = getWallNormal(cx, cy)
		if ny < 0 then
			land(me)
			entity_setState(me, STATE_TRANSITION)
		else
			bounces = bounces + 1
			if bounces > 8 then
				land(me)
				entity_setState(me, STATE_TRANSITION)
			end
		end
	end
	]]--
end

function enterState(me)
	if entity_getState(me)==STATE_IDLE then
		entity_animate(me, "idle", LOOP_INF)
		entity_setMaxSpeed(me, 1200)
	elseif entity_getState(me)==STATE_JUMPPREP then

		nx,ny = entity_getNormal(me)
		for i=20,400,20 do
			
			nx1,ny1 = vector_setLength(nx, ny, i)
			tx = entity_x(me) + nx1
			ty = entity_y(me) + ny1
			--debugLog(string.format("t(%d, %d)", tx, ty))
			if isObstructed(tx, ty) then
				--debugLog("idle!")
				entity_setState(me, STATE_WALK, 2, 1)
				return
			end
		end
		
		entity_animate(me, "jumpPrep")
		entity_flipToEntity(me, entity_getTarget(me))
	elseif entity_isState(me, STATE_TRANSITION) then
		entity_setStateTime(me, entity_animate(me, "land"))
	elseif entity_isState(me, STATE_WALK) then
		entity_animate(me, "walk", -1)
	elseif entity_getState(me)==STATE_JUMP then
		bounces = 0
		entity_flipToEntity(me, entity_getTarget(me))
		entity_animate(me, "jump")
		
		rotateOffset = 0
		entity_applySurfaceNormalForce(me, 1000)
		if entity_isfh(me) then
			entity_addVel(me, 400, 0)
		else
			entity_addVel(me, -400, 0)
		end
		entity_adjustPositionBySurfaceNormal(me, 10)
		
		entity_sound(me, "mermog-jump")
		--entity_adjustPositionBySurfaceNormal(me, 32)
	end
end

function animationKey(me, key)
	if entity_isState(me, STATE_RUNAWAY) and ((key > 3 and key < 5) or (key == 1)) then
		moving = 1
	else
		moving = 0.2
	end
end

function exitState(me)
	if entity_getState(me)==STATE_TRANSITION then
		entity_setState(me, STATE_IDLE)
		if chance(50) then
			entity_setState(me, STATE_WALK, 2)
		end
	elseif entity_getState(me)==STATE_WALK then
		entity_setState(me, STATE_IDLE)
	end
end

function dieNormal(me)
	if chance(20) then
		x,y = entity_getNormal(me)
		x,y = vector_setLength(x, y, 64)
		spawnIngredient("PlantLeaf", entity_x(me)+x, entity_y(me)+y)
	end
end
