dofile("scripts/entities/entityinclude.lua")

n = 0

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_NEUTRAL)
	entity_initSkeletal(me, "merwoman")
	
	entity_scale(me, 0.6, 0.6)
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
	
	nd = entity_getNearestNode(me, "skin1")
	if nd~=0 and node_isEntityIn(nd, me) then
		entity_initSkeletal(me, "merwoman", "merwoman-skin1")
	end
	
	nd = entity_getNearestNode(me, "skin2")
	if nd~=0 and node_isEntityIn(nd, me) then
		entity_initSkeletal(me, "merwoman", "merwoman-skin2")
	end
	
	entity_animate(me, "idle", -1)
	
	nd = entity_getNearestNode(me, "flip")
	if nd~=0 and node_isEntityIn(nd, me) then
		entity_fh(me)
	end
	
	nd = entity_getNearestNode(me, "sit")
	if nd~=0 and node_isEntityIn(nd, me) then
		debugLog("animating SIT")
		entity_animate(me, "sit", -1)
	end
	
	
end

function update(me, dt)
	entity_updateMovement(me, dt)
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		--entity_animate(me, "idle", -1)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

